/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateViewAsStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateViewFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Named;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResultQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQL;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartListView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;
import java.util.function.BiFunction;

final class CreateViewImpl<R extends Record>
extends AbstractDDLQuery
implements CreateViewAsStep<R>,
CreateViewFinalStep,
QOM.CreateView<R> {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final boolean ifNotExists;
    private final boolean orReplace;
    private final Table<?> view;
    private final BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction;
    private Field<?>[] fields;
    private ResultQuery<?> select;
    private transient Select<?> parsed;

    CreateViewImpl(Configuration configuration, Table<?> view, Field<?>[] fields, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = fields;
        this.fieldNameFunction = null;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    CreateViewImpl(Configuration configuration, Table<?> view, BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = null;
        this.fieldNameFunction = fieldNameFunction;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    @Override
    public final CreateViewFinalStep as(Select<? extends R> s2) {
        this.select = s2;
        if (this.fieldNameFunction != null) {
            this.fields = Tools.map(s2.getSelect(), this.fieldNameFunction::apply, Field[]::new);
        }
        return this;
    }

    @Override
    public final CreateViewFinalStep as(SQL sql) {
        this.select = DSL.resultQuery(sql);
        if (this.fieldNameFunction != null) {
            this.fields = Tools.map(this.parsed().getSelect(), this.fieldNameFunction::apply, Field[]::new);
        }
        return this;
    }

    @Override
    public final CreateViewFinalStep as(String sql) {
        return this.as(DSL.sql(sql));
    }

    @Override
    public final CreateViewFinalStep as(String sql, Object ... bindings) {
        return this.as(DSL.sql(sql, bindings));
    }

    @Override
    public final CreateViewFinalStep as(String sql, QueryPart ... parts) {
        return this.as(DSL.sql(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        QueryPart[] f = this.fields;
        boolean rename = f != null && f.length > 0;
        boolean renameSupported = true;
        boolean replaceSupported = false;
        ctx.start(Clause.CREATE_VIEW_NAME).visit(replaceSupported && this.orReplace ? Keywords.K_REPLACE : Keywords.K_CREATE);
        if (this.orReplace && !replaceSupported) {
            ctx.sql(' ').visit(Keywords.K_OR);
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.sql(' ').visit(Keywords.K_ALTER);
                    break;
                }
                default: {
                    ctx.sql(' ').visit(Keywords.K_REPLACE);
                }
            }
        }
        ctx.sql(' ').visit(Keywords.K_VIEW).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        if (rename && renameSupported) {
            ctx.sql('(').visit(QueryPartListView.wrap((QueryPart[])f).qualify(false)).sql(')');
        }
        ctx.end(Clause.CREATE_VIEW_NAME).formatSeparator().visit(Keywords.K_AS).formatSeparator().start(Clause.CREATE_VIEW_AS).visit(rename && !renameSupported ? DSL.selectFrom(this.parsed().asTable(DSL.name("t"), Tools.map(f, Named::getUnqualifiedName, Name[]::new))) : this.select, ParamType.INLINED).end(Clause.CREATE_VIEW_AS);
    }

    private final Select<?> parsed() {
        if (this.parsed != null) {
            return this.parsed;
        }
        if (this.select instanceof Select) {
            this.parsed = (Select)this.select;
            return this.parsed;
        }
        DSLContext dsl = this.configuration().dsl();
        return dsl.parser().parseSelect(dsl.renderInlined(this.select));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final boolean $orReplace() {
        return this.orReplace;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $fields() {
        return QOM.unmodifiable((QueryPart[])this.fields);
    }

    @Override
    public final ResultQuery<R> $query() {
        return this.select;
    }

    final Select<?> $select() {
        return this.parsed();
    }
}

