/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.XML;
import io.lumine.mythic.bukkit.utils.lib.jooq.XMLAttributes;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartCollectionView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.XMLAttributesImpl;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

final class XMLElement
extends AbstractField<XML>
implements QOM.XMLElement {
    private final Name elementName;
    private final XMLAttributes attributes;
    private final QueryPartList<Field<?>> content;

    XMLElement(Name elementName, XMLAttributes attributes, Collection<? extends Field<?>> content) {
        super(Names.N_XMLELEMENT, SQLDataType.XML);
        this.elementName = elementName;
        this.attributes = attributes == null ? XMLAttributesImpl.EMPTY : attributes;
        this.content = new QueryPartList((Iterable<Field<?>>)content);
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean hasContent = !this.content.isEmpty();
        boolean hasAttributes = !((XMLAttributesImpl)this.attributes).attributes.isEmpty();
        boolean format = hasAttributes || !this.content.isSimple(ctx);
        Consumer<Context> accept0 = c -> {
            c.visit(Keywords.K_NAME).sql(' ').visit(this.elementName);
            if (hasAttributes) {
                if (format) {
                    c.sql(',').formatSeparator().visit(this.attributes);
                } else {
                    c.sql(", ").visit(this.attributes);
                }
            }
            if (hasContent) {
                if (format) {
                    c.sql(',').formatSeparator().visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
                } else {
                    c.sql(", ").visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
                }
            }
        };
        ctx.visit(Names.N_XMLELEMENT).sql('(');
        if (format) {
            ctx.formatIndentStart().formatNewLine().data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true, c -> accept0.accept((Context)c)).formatIndentEnd().formatNewLine();
        } else {
            accept0.accept(ctx);
        }
        ctx.sql(')');
    }

    static final Function<? super Field<?>, ? extends Field<?>> xmlCastMapper(Context<?> ctx) {
        return field -> XMLElement.xmlCast(ctx, field);
    }

    static final Field<?> xmlCast(Context<?> ctx, Field<?> field) {
        Field<?> result = field;
        DataType type = field.getDataType();
        switch (ctx.family()) {
            default: 
        }
        if (result != field && Tools.aliased(field) != null) {
            return result.as(field);
        }
        return result;
    }

    @Override
    public final Name $elementName() {
        return this.elementName;
    }

    @Override
    public final XMLAttributes $attributes() {
        return this.attributes;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $content() {
        return QOM.unmodifiable(this.content);
    }
}

