/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc;

import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBC41Connection;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.MockArray;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.MockDataProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.MockSavepoint;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.MockStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class MockConnection
extends JDBC41Connection
implements Connection {
    private final MockDataProvider data;
    private boolean isClosed;

    public MockConnection(MockDataProvider data) {
        this.data = data;
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is already closed");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        MockStatement result = new MockStatement(this, this.data);
        result.resultSetType = resultSetType;
        result.resultSetConcurrency = resultSetConcurrency;
        result.resultSetHoldability = resultSetHoldability;
        return result;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        MockStatement result = new MockStatement(this, this.data, sql);
        result.resultSetType = resultSetType;
        result.resultSetConcurrency = resultSetConcurrency;
        result.resultSetHoldability = resultSetHoldability;
        return result;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        MockStatement result = new MockStatement(this, this.data, sql);
        result.autoGeneratedKeys = autoGeneratedKeys;
        return result;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkNotClosed();
        MockStatement result = new MockStatement(this, this.data, sql);
        result.autoGeneratedKeys = 1;
        result.columnIndexes = columnIndexes;
        return result;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkNotClosed();
        MockStatement result = new MockStatement(this, this.data, sql);
        result.autoGeneratedKeys = 1;
        result.columnNames = columnNames;
        return result;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        MockStatement result = new MockStatement(this, this.data, sql);
        result.resultSetType = resultSetType;
        result.resultSetConcurrency = resultSetConcurrency;
        result.resultSetHoldability = resultSetHoldability;
        return result;
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkNotClosed();
        return new MockSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkNotClosed();
        return new MockSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new MockArray<Object>(SQLDialect.DEFAULT, elements, elements == null ? Object[].class : elements.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("MockConnection does not implement " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }
}

