/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

import java.util.regex.Pattern;

public class RandomDouble {
    private static Pattern PATTERN = Pattern.compile("^-?[0-9]*(\\.\\d+)?(to|-)?[0-9]\\d*(\\.\\d+)?");
    private static Pattern PATTERN_RANGE = Pattern.compile("^-?[0-9]*(\\.\\d+)?(to|-)+[0-9]\\d*(\\.\\d+)?");
    private boolean isStatic;
    private double min;
    private double max;

    public RandomDouble(double i) {
        this.min = i;
        this.max = i;
        this.isStatic = true;
    }

    public RandomDouble(double i, double j) {
        this.min = i;
        this.max = j;
        this.isStatic = false;
    }

    public RandomDouble(String value) {
        try {
            if (value.contains("to")) {
                String[] split = value.split("to");
                this.min = Double.valueOf(split[0]);
                this.max = Double.valueOf(split[1]);
                this.isStatic = false;
            } else if (!value.startsWith("-") && value.contains("-")) {
                String[] split = value.split("-");
                this.min = Double.valueOf(split[0]);
                this.max = Double.valueOf(split[1]);
                this.isStatic = false;
            } else {
                this.min = Double.valueOf(value);
                this.max = Double.valueOf(value);
                this.isStatic = true;
            }
        }
        catch (Exception ex) {
            this.min = 1.0;
            this.max = 1.0;
            this.isStatic = true;
            ex.printStackTrace();
        }
    }

    public double get() {
        if (this.isStatic) {
            return this.min;
        }
        return this.min + Math.random() * (this.max - this.min);
    }

    public String toString() {
        return "RandomDouble{" + this.min + " to " + this.max + "}";
    }

    public static boolean matches(String value) {
        return PATTERN.matcher(value).matches();
    }

    public static boolean matchesRange(String value) {
        return PATTERN_RANGE.matcher(value).matches();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

