/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.papi;

import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public abstract class Placeholder<T extends LuminePlugin> {
    protected final T plugin;
    protected final Map<String, Placeholder<T>> nestedPlaceholders = new HashMap<String, Placeholder<T>>();

    public Placeholder(T plugin) {
        this.plugin = plugin;
    }

    public Placeholder(Placeholder<T> parent) {
        this.plugin = parent.getPlugin();
    }

    public void registerNestedPlaceholders(Placeholder<T> ... placeholders) {
        for (Placeholder<T> placeholder : placeholders) {
            this.nestedPlaceholders.put(placeholder.getName(), placeholder);
        }
    }

    public String processPlaceholder(Player player, String[] args) {
        Placeholder<T> sub;
        if (this.requiresPlayer() && player == null) {
            return "";
        }
        if (args.length > 0 && (sub = this.nestedPlaceholders.get(args[0].toLowerCase())) != null) {
            return this.processPlaceholder(player, Arrays.copyOfRange(args, 1, args.length));
        }
        return this.onPlaceholderRequest(player, args);
    }

    public abstract String onPlaceholderRequest(Player var1, String[] var2);

    public abstract String getName();

    public abstract boolean requiresPlayer();

    protected String processNestedPlaceholders(Player player, String[] args) {
        if (args.length == 0) {
            return "";
        }
        Placeholder<T> placeholder = this.nestedPlaceholders.get(args[0]);
        if (placeholder == null) {
            return "";
        }
        String[] nestedArgs = new String[args.length - 1];
        System.arraycopy(args, 1, nestedArgs, 0, nestedArgs.length);
        return placeholder.onPlaceholderRequest(player, nestedArgs);
    }

    public T getPlugin() {
        return this.plugin;
    }
}

