/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.scoreboard;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.lumine.mythic.bukkit.utils.annotation.NonnullByDefault;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.protocol.Protocol;
import io.lumine.mythic.bukkit.utils.scoreboard.ScoreboardObjective;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;

@NonnullByDefault
public class PacketScoreboardObjective
implements ScoreboardObjective {
    private static final int MAX_SCORE_LENGTH = 40;
    private static final int MAX_NAME_LENGTH = 32;
    private final String id;
    private boolean autoSubscribe;
    private final Map<String, Integer> scores = Collections.synchronizedMap(new HashMap());
    private final Set<Player> subscribed = Collections.synchronizedSet(new HashSet());
    private String displayName;
    private DisplaySlot displaySlot;

    private static String trimScore(String name) {
        return name.length() > 40 ? name.substring(0, 40) : name;
    }

    private static String trimName(String name) {
        return name.length() > 32 ? name.substring(0, 32) : name;
    }

    public PacketScoreboardObjective(String id, String displayName, DisplaySlot displaySlot, boolean autoSubscribe) {
        Objects.requireNonNull(id, "id");
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        this.id = id;
        this.displayName = PacketScoreboardObjective.trimName(ColorString.get(Objects.requireNonNull(displayName, "displayName")));
        this.displaySlot = Objects.requireNonNull(displaySlot, "displaySlot");
        this.autoSubscribe = autoSubscribe;
    }

    public PacketScoreboardObjective(String id, String displayName, DisplaySlot displaySlot) {
        this(id, displayName, displaySlot, true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean shouldAutoSubscribe() {
        return this.autoSubscribe;
    }

    @Override
    public void setAutoSubscribe(boolean autoSubscribe) {
        this.autoSubscribe = autoSubscribe;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        Objects.requireNonNull(displayName, "displayName");
        displayName = PacketScoreboardObjective.trimName(ColorString.get(displayName));
        if (this.displayName.equals(displayName)) {
            return;
        }
        this.displayName = displayName;
        Protocol.broadcastPacket(this.subscribed, this.newObjectivePacket(UpdateType.UPDATE));
    }

    @Override
    public DisplaySlot getDisplaySlot() {
        return this.displaySlot;
    }

    @Override
    public void setDisplaySlot(DisplaySlot displaySlot) {
        Objects.requireNonNull(displaySlot, "displaySlot");
        if (this.displaySlot == displaySlot) {
            return;
        }
        this.displaySlot = displaySlot;
        Protocol.broadcastPacket(this.subscribed, this.newDisplaySlotPacket(displaySlot));
    }

    @Override
    public Map<String, Integer> getScores() {
        return ImmutableMap.copyOf(this.scores);
    }

    @Override
    public boolean hasScore(String name) {
        Objects.requireNonNull(name, "name");
        return this.scores.containsKey(PacketScoreboardObjective.trimScore(ColorString.get(name)));
    }

    @Override
    @Nullable
    public Integer getScore(String name) {
        Objects.requireNonNull(name, "name");
        return this.scores.get(PacketScoreboardObjective.trimScore(ColorString.get(name)));
    }

    @Override
    public void setScore(String name, int value) {
        Objects.requireNonNull(name, "name");
        name = PacketScoreboardObjective.trimScore(ColorString.get(name));
        Integer oldValue = this.scores.put(name, value);
        if (oldValue != null && oldValue == value) {
            return;
        }
        Protocol.broadcastPacket(this.subscribed, this.newScorePacket(name, value, EnumWrappers.ScoreboardAction.CHANGE));
    }

    @Override
    public boolean removeScore(String name) {
        Objects.requireNonNull(name, "name");
        name = PacketScoreboardObjective.trimScore(ColorString.get(name));
        if (this.scores.remove(name) == null) {
            return false;
        }
        Protocol.broadcastPacket(this.subscribed, this.newScorePacket(name, 0, EnumWrappers.ScoreboardAction.REMOVE));
        return true;
    }

    @Override
    public void clearScores() {
        this.scores.clear();
        Protocol.broadcastPacket(this.subscribed, this.newObjectivePacket(UpdateType.REMOVE));
        for (Player player : this.subscribed) {
            this.subscribe(player);
        }
    }

    @Override
    public void applyScores(Map<String, Integer> scores) {
        Objects.requireNonNull(scores, "scores");
        HashSet<String> toRemove = new HashSet<String>(this.getScores().keySet());
        for (Map.Entry<String, Integer> score : scores.entrySet()) {
            toRemove.remove(PacketScoreboardObjective.trimScore(ColorString.get(score.getKey())));
        }
        for (String name : toRemove) {
            this.removeScore(name);
        }
        for (Map.Entry<String, Integer> score : scores.entrySet()) {
            this.setScore(score.getKey(), score.getValue());
        }
    }

    @Override
    public void applyLines(String ... lines) {
        this.applyLines(Arrays.asList(lines));
    }

    @Override
    public void applyLines(Collection<String> lines) {
        Objects.requireNonNull(lines, "lines");
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        int i = lines.size();
        for (String line : lines) {
            scores.put(line, i--);
        }
        this.applyScores(scores);
    }

    @Override
    public void subscribe(Player player) {
        Objects.requireNonNull(player, "player");
        Protocol.sendPacket(player, this.newObjectivePacket(UpdateType.CREATE));
        Protocol.sendPacket(player, this.newDisplaySlotPacket(this.getDisplaySlot()));
        for (Map.Entry<String, Integer> score : this.getScores().entrySet()) {
            Protocol.sendPacket(player, this.newScorePacket(score.getKey(), score.getValue(), EnumWrappers.ScoreboardAction.CHANGE));
        }
        this.subscribed.add(player);
    }

    @Override
    public void unsubscribe(Player player) {
        this.unsubscribe(player, false);
    }

    @Override
    public void unsubscribe(Player player, boolean fast) {
        Objects.requireNonNull(player, "player");
        if (!this.subscribed.remove(player) || fast) {
            return;
        }
        Protocol.sendPacket(player, this.newObjectivePacket(UpdateType.REMOVE));
    }

    @Override
    public void unsubscribeAll() {
        Protocol.broadcastPacket(this.subscribed, this.newObjectivePacket(UpdateType.REMOVE));
        this.subscribed.clear();
    }

    private PacketContainer newObjectivePacket(UpdateType mode) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        packet.getStrings().write(0, (Object)this.getId());
        packet.getIntegers().write(0, (Object)mode.getCode());
        packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)this.getDisplayName()));
        packet.getEnumModifier(HealthDisplay.class, 2).write(0, (Object)HealthDisplay.INTEGER);
        return packet;
    }

    private PacketContainer newScorePacket(String name, int value, EnumWrappers.ScoreboardAction action) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().write(0, (Object)name);
        packet.getScoreboardActions().write(0, (Object)action);
        packet.getStrings().write(1, (Object)this.getId());
        packet.getIntegers().write(0, (Object)value);
        return packet;
    }

    private PacketContainer newDisplaySlotPacket(DisplaySlot displaySlot) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_DISPLAY_OBJECTIVE);
        packet.getIntegers().write(0, (Object)(switch (displaySlot) {
            case DisplaySlot.PLAYER_LIST -> 0;
            case DisplaySlot.SIDEBAR -> 1;
            case DisplaySlot.BELOW_NAME -> 2;
            default -> throw new RuntimeException();
        }));
        packet.getStrings().write(0, (Object)this.getId());
        return packet;
    }

    private static enum UpdateType {
        CREATE(0),
        REMOVE(1),
        UPDATE(2);

        private final int code;

        private UpdateType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static enum HealthDisplay {
        INTEGER,
        HEARTS;

    }
}

