/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.version.wrappers;

import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.version.wrappers.VersionItemHandler;
import org.bukkit.Bukkit;

public abstract class VersionWrapper {
    private static VersionWrapper wrapper = null;

    public static final VersionWrapper get() {
        if (wrapper != null) {
            return wrapper;
        }
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (version.equals("v1_19_R1") && !"1.19-R0.1-SNAPSHOT".equals(Bukkit.getBukkitVersion())) {
            version = "v1_19_R1_2";
        }
        try {
            Class<?> clazz = Class.forName("io.lumine.mythic.bukkit.utils.nms.VersionWrapper_" + version);
            if (VersionWrapper.class.isAssignableFrom(clazz)) {
                wrapper = (VersionWrapper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            Log.error("No compatible Bukkit version found");
            Log.error("Server NMS Version Detected - {0}", version);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. NMS has been disabled.", e);
        }
        return wrapper;
    }

    public abstract VersionItemHandler getItemHandler();
}

