/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.holograms;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.holograms.HologramProvider;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.utils.adventure.text.Component;
import io.lumine.mythic.bukkit.utils.adventure.text.TextComponent;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.holograms.DisplayHologram;
import io.lumine.mythic.core.holograms.HologramManager;
import java.util.Collection;
import java.util.function.Supplier;

public class DisplayHologramProvider
implements HologramProvider {
    private final HologramManager manager;

    public DisplayHologramProvider(HologramManager manager) {
        this.manager = manager;
    }

    @Override
    public IHologram createHologram(String name, AbstractLocation location, String text) {
        TextComponent line = Component.text(text);
        PacketTextDisplay.PacketTextDisplayBuilder options = PacketTextDisplay.create().lineWidth(200).scale(new AbstractVector(1, 1, 1)).yOffset(Float.valueOf(2.0f)).textComponent(line);
        return new DisplayHologram(this.manager, location, options);
    }

    @Override
    public IHologram createHologram(Supplier<Collection<AbstractPlayer>> audience, AbstractEntity entity, String text, PacketTextDisplay.PacketTextDisplayBuilder options) {
        Component line;
        if (text.contains("\\n")) {
            String[] splits = text.split("\\\\n");
            Component comp = Text.parse(splits[0]);
            for (int i = 1; i < splits.length; ++i) {
                comp = comp.appendNewline().append(Text.parse(splits[i]));
            }
            line = comp;
        } else {
            line = Text.parse(text);
        }
        options.textComponent(line);
        return new DisplayHologram(this.manager, audience, entity, options);
    }

    @Override
    public IHologram createHologram(AbstractEntity entity, String text, PacketTextDisplay.PacketTextDisplayBuilder options) {
        Component line;
        if (text.contains("\\n")) {
            String[] splits = text.split("\\\\n");
            Component comp = Text.parse(splits[0]);
            for (int i = 1; i < splits.length; ++i) {
                comp = comp.appendNewline().append(Text.parse(splits[i]));
            }
            line = comp;
        } else {
            line = Text.parse(text);
        }
        options.textComponent(line);
        return new DisplayHologram(this.manager, entity, options);
    }

    @Override
    public void cleanup() {
    }
}

