/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.logging;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import java.io.File;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class MythicLogger {
    public static void log(String message) {
        MythicBukkit.inst().getLogger().log(Level.INFO, message + ConsoleColor.RESET);
    }

    public static void log(String message, Object ... params) {
        MythicBukkit.inst().getLogger().log(Level.INFO, message + ConsoleColor.RESET, params);
    }

    public static void log(Level level, String message) {
        MythicBukkit.inst().getLogger().log(level, message + ConsoleColor.RESET);
    }

    public static void log(Level level, String message, Object ... params) {
        MythicBukkit.inst().getLogger().log(level, message + ConsoleColor.RESET, params);
    }

    public static void error(String message) {
        MythicLogger.log(Level.WARNING, message + ConsoleColor.RESET);
    }

    public static void error(SkillCaster caster, String message) {
        String source;
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            source = ConsoleColor.PURPLE + "[" + ConsoleColor.YELLOW + "MobType=" + am.getType().getInternalName() + ConsoleColor.PURPLE + "]";
        } else {
            source = ConsoleColor.PURPLE + "[" + ConsoleColor.YELLOW + "Caster=" + caster.getName() + ConsoleColor.PURPLE + "]";
        }
        MythicLogger.log(Level.WARNING, source + " " + message + ConsoleColor.RESET);
    }

    public static void error(String message, Object ... params) {
        MythicLogger.log(Level.WARNING, message + ConsoleColor.RESET, params);
    }

    public static void error(SkillCaster caster, String message, Object ... params) {
        String source;
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            source = ConsoleColor.PURPLE + "[" + ConsoleColor.YELLOW + "MobType=" + am.getType().getInternalName() + ConsoleColor.PURPLE + "]";
        } else {
            source = ConsoleColor.PURPLE + "[" + ConsoleColor.YELLOW + "Caster=" + caster.getName() + ConsoleColor.PURPLE + "]";
        }
        MythicLogger.log(Level.WARNING, source + " " + message + ConsoleColor.RESET, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex) {
        MythicLogger.log(Level.SEVERE, message + ConsoleColor.RESET);
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() > 0) {
            ex.printStackTrace();
        }
        if (MythicBukkit.inst().getConfiguration().getDoErrorLogging().booleanValue()) {
            try (PrintWriter writer = null;){
                File folder = new File(MythicBukkit.inst().getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
                    t2.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft forums or discord.");
                writer.println("MythicMobs version: " + MythicBukkit.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex, Object ... params) {
        MythicLogger.log(Level.SEVERE, message + ConsoleColor.RESET, params);
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() > 0) {
            ex.printStackTrace();
        }
        if (MythicBukkit.inst().getConfiguration().getDoErrorLogging().booleanValue()) {
            try (PrintWriter writer = null;){
                File folder = new File(MythicBukkit.inst().getDataFolder(), "Error Logs");
                if (!folder.exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
                    t2.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft forums or discord.");
                writer.println("MythicMobs version: " + MythicBukkit.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    public static void handleMinorError(Throwable ex) {
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() > 0) {
            ex.printStackTrace();
        }
    }

    public static void errorYMLConfig(File file, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.ERROR_MARK + ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Failed to load YML File");
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + file.getAbsolutePath());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorGenericConfig(String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + " Configuration Error: " + ConsoleColor.RESET + error);
    }

    public static void errorGenericConfig(MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error");
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFile().getAbsolutePath());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorGenericConfig(MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error");
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFileName());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Line: " + ConsoleColor.RESET + config.getLine());
    }

    public static void errorMobConfig(MythicMob mob, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in Mob " + ConsoleColor.CYAN + mob.getInternalName());
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFile().getAbsolutePath());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorEntityConfig(BukkitEntityType entity, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Entity Configuration Error in Mob " + ConsoleColor.CYAN + config.getKey());
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFile().getAbsolutePath());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorMechanic(SkillMechanic mechanic, String error) {
        MythicLogger.errorMechanic(mechanic, error, null);
    }

    public static void errorMechanic(SkillMechanic mechanic, String error, Throwable ex) {
        Object parentString;
        Optional<SkillHolder> maybeParent = mechanic.getParent();
        MythicLineConfig config = mechanic.getConfig();
        if (maybeParent.isEmpty()) {
            parentString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof MobType) {
                MobType mobType = (MobType)skillHolder;
                parentString = "Mob: " + ConsoleColor.WHITE + mobType.getInternalName() + ConsoleColor.CYAN + " | " + ConsoleColor.RED;
            } else {
                parentString = "Skill: " + ConsoleColor.WHITE + maybeParent.get().getInternalName() + ConsoleColor.CYAN + " | " + ConsoleColor.RED;
            }
        }
        MythicLogger.error("--| " + ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " An Error Occurred in Mechanic " + ConsoleColor.CYAN + mechanic.getTypeName());
        MythicLogger.error("--| " + ConsoleColor.RED + (String)parentString + "File: " + ConsoleColor.WHITE + mechanic.getFilePath());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Mechanic: " + ConsoleColor.RESET + config.getLine());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error: " + ConsoleColor.RESET + error);
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    public static void errorMechanicConfig(SkillMechanic mechanic, MythicLineConfig config, String error) {
        Object parentString;
        Optional<SkillHolder> maybeParent = mechanic.getParent();
        if (maybeParent.isEmpty()) {
            parentString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof MobType) {
                MobType mobType = (MobType)skillHolder;
                parentString = "Mob: " + ConsoleColor.CYAN + mobType.getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
            } else {
                parentString = "Skill: " + ConsoleColor.CYAN + maybeParent.get().getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
            }
        }
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in Mechanic " + ConsoleColor.CYAN + mechanic.getTypeName());
        MythicLogger.error("--| " + ConsoleColor.RED + (String)parentString + "File: " + ConsoleColor.WHITE + mechanic.getFilePath());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Mechanic Line: " + ConsoleColor.RESET + config.getLine());
    }

    public static void errorCondition(SkillCondition condition, String error) {
        MythicLogger.errorCondition(condition, error, null);
    }

    public static void errorCondition(SkillCondition condition, String error, Throwable ex) {
        String fileString;
        Object parentString;
        Optional<SkillHolder> maybeParent = condition.getParent();
        if (maybeParent.isEmpty()) {
            parentString = "";
            fileString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof SkillMechanic) {
                SkillMechanic mechanic = (SkillMechanic)skillHolder;
                parentString = "Mechanic: " + ConsoleColor.CYAN + mechanic.getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
                fileString = mechanic.getConfig().getFileName();
            } else {
                skillHolder = maybeParent.get();
                if (skillHolder instanceof MetaSkill) {
                    MetaSkill metaSkill = (MetaSkill)skillHolder;
                    parentString = "Mechanic: " + ConsoleColor.CYAN + metaSkill.getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
                    fileString = metaSkill.getFile().getAbsolutePath();
                } else {
                    parentString = "Skill: " + ConsoleColor.CYAN + maybeParent.get().getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
                    fileString = "";
                }
            }
        }
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in Condition " + ConsoleColor.CYAN + condition.getTypeName());
        if (!((String)parentString).isEmpty() || !fileString.isEmpty()) {
            MythicLogger.error("--| " + ConsoleColor.RED + (String)parentString + "File: " + ConsoleColor.WHITE + fileString);
        }
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Condition Line: " + ConsoleColor.RESET + condition.getLine());
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    public static void errorConditionConfig(SkillCondition condition, MythicLineConfig config, String error) {
        Object parentString;
        Optional<SkillHolder> maybeParent = condition.getParent();
        if (maybeParent.isEmpty()) {
            parentString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof SkillMechanic) {
                SkillMechanic mechanic = (SkillMechanic)skillHolder;
                parentString = "Mechanic: " + ConsoleColor.CYAN + mechanic.getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
            } else {
                parentString = "Skill: " + ConsoleColor.CYAN + maybeParent.get().getInternalName() + ConsoleColor.WHITE + " | " + ConsoleColor.RED;
            }
        }
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in Condition " + ConsoleColor.CYAN + condition.getTypeName());
        MythicLogger.error("--| " + ConsoleColor.RED + (String)parentString + "File: " + ConsoleColor.WHITE + config.getFileName());
        MythicLogger.error("--| " + ConsoleColor.YELLOW + "Error Message: " + ConsoleColor.RESET + error);
        MythicLogger.error("--| " + ConsoleColor.YELLOW + "Mechanic Line: " + ConsoleColor.RESET + config.getLine());
    }

    public static void errorItemConfig(MythicItem item, MythicConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in Item " + ConsoleColor.CYAN + config.getKey());
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFileName());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorDropConfig(Drop drop, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in Drop " + ConsoleColor.CYAN + drop.getLine());
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFileName());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorDropTableConfig(DropTable drop, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in DropTable " + ConsoleColor.CYAN + drop.getInternalName());
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + config.getFileName());
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorTargeterConfig(SkillTargeter targeter, MythicLineConfig config, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Targeter line '" + ConsoleColor.UNDERLINE + config.getLine() + ConsoleColor.RESET + ConsoleColor.YELLOW + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorTargeterConfig(SkillTargeter targeter, SkillCaster caster, MythicLineConfig config, String error) {
        MythicLogger.error(caster, ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Config Error for Targeter line '" + ConsoleColor.UNDERLINE + config.getLine() + ConsoleColor.RESET + ConsoleColor.YELLOW + "': " + ConsoleColor.WHITE + error);
    }

    public static void errorSpawnConfig(RandomSpawner spawner, MythicConfig config, String error) {
        String fileName = config.getFile() == null ? "Unknown" : config.getFile().getAbsolutePath();
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.RED + ConsoleColor.BOLD + " Configuration Error in RandomSpawn " + ConsoleColor.CYAN + spawner.getName());
        MythicLogger.error("--| " + ConsoleColor.RED + "File: " + ConsoleColor.WHITE + fileName);
        MythicLogger.error("--| " + ConsoleColor.PURPLE + "Error Message: " + ConsoleColor.RESET + error);
    }

    public static void errorCompatibility(String plugin, String error) {
        MythicLogger.error(ConsoleColor.ERROR_MARK + ConsoleColor.YELLOW + " Compatibility Error for '" + ConsoleColor.UNDERLINE + plugin + ConsoleColor.RESET + ConsoleColor.YELLOW + "': " + ConsoleColor.WHITE + error);
    }

    public static void debug(DebugLevel level, String message, Object ... params) {
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() == 0) {
            return;
        }
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() < level.ordinal()) {
            return;
        }
        switch (level) {
            case INFO: {
                MythicLogger.log(Level.INFO, ConsoleColor.CYAN + "[i] " + message, params);
                return;
            }
            case SKILL: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "+--- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case SKILL_CHECK: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "|----- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case SKILL_INFO: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "|------- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case MECHANIC: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "~----------- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case CONDITION: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "|--------? " + ConsoleColor.CYAN + message, params);
                return;
            }
            case TRIGGER: {
                MythicLogger.log(Level.INFO, ConsoleColor.PURPLE + "#- " + ConsoleColor.CYAN + message, params);
                return;
            }
            case EVENT: {
                MythicLogger.log(Level.INFO, ConsoleColor.CYAN + "[e] " + message, params);
                return;
            }
            case CLOCK: {
                MythicLogger.log(Level.INFO, ConsoleColor.CYAN + "[c] " + message, params);
                return;
            }
        }
    }

    private MythicLogger() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static enum DebugLevel {
        NONE,
        INFO,
        SKILL,
        SKILL_CHECK,
        SKILL_INFO,
        MECHANIC,
        CONDITION,
        TRIGGER,
        EVENT,
        CLOCK;

    }
}

