/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items.editor;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.menus.items.ItemEditorButton;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditGroupButton
extends ItemEditorButton {
    public EditGroupButton(ItemEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public Icon<ItemEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.CHEST).name("<green>Set Group/ItemType").lore(context -> Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>" + context.getItem().getGroup()})).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the Group you'd like to assign.", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                MythicItem item = context.getItem();
                MythicConfig config = item.getConfig();
                item.setGroup(input);
                String key = config.determineWhichKeyToUse("Group", "ItemType", "Options.Group", "Options.ItemType");
                config.setSave(key, input);
                item.buildItemCache();
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).build();
    }
}

