/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.ai.goals;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.core.mobs.ai.Pathfinder;
import io.lumine.mythic.core.mobs.ai.PathfindingGoal;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import java.util.List;

@MythicAIGoal(name="doNothing", aliases={"nothing"}, version="4.9", description="Do nothing if the conditions are met", premium=true)
public class DoNothingGoal
extends Pathfinder
implements PathfindingGoal {
    protected String conditionString;
    protected List<SkillCondition> conditions = null;

    public DoNothingGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.goalType = Pathfinder.GoalType.MOVE_LOOK;
        this.conditionString = mlc.getString(new String[]{"fleeconditions", "conditions", "cond", "c"}, "null", new String[0]);
        if (this.conditionString != null) {
            this.conditions = DoNothingGoal.getPlugin().getSkillManager().getConditions(this.conditionString);
        }
    }

    @Override
    public boolean shouldStart() {
        if (this.conditions == null) {
            return true;
        }
        try {
            for (SkillCondition cond : this.conditions) {
                if (cond.evaluateEntity(this.entity)) continue;
                return false;
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean shouldEnd() {
        if (this.conditions == null) {
            return false;
        }
        try {
            for (SkillCondition cond : this.conditions) {
                if (cond.evaluateEntity(this.entity)) continue;
                return true;
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void end() {
    }
}

