/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Phil", name="entityitemissimilar", aliases={}, description="Tests if the item entity is similar to an itemstack")
public class EntityItemIsSimilarCondition
extends SkillCondition
implements IEntityCondition {
    private BukkitItemStack item;

    public EntityItemIsSimilarCondition(String line, MythicLineConfig config) {
        super(line);
        String materialString = config.getString(new String[]{"item", "i", "material", "m", "mm", "mythicitem"}, "DIRT", new String[0]);
        try {
            this.item = new BukkitItemStack(materialString);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorConditionConfig(this, config, "'" + materialString + "' is not a valid material.");
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof Item)) {
            return false;
        }
        Item entity2 = (Item)entity;
        ItemStack itemStack = entity2.getItemStack();
        return this.item.isSimilar(itemStack);
    }
}

