/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;

@MythicCondition(author="Joshinn", name="moisturelevel", aliases={"moistness", "moistureness"}, description="Whether or not a location of farmland has specific moisture.")
public class MoistureCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="level", aliases={"l", "m", "moistness"}, description="The level to check for")
    private final PlaceholderInt level;

    public MoistureCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.level = mlc.getPlaceholderInteger(new String[]{"l", "m", "moistness"}, 7, new String[0]);
    }

    @Override
    public boolean check(AbstractLocation l) {
        BlockData blockData = BukkitAdapter.adapt(l).getBlock().getBlockData();
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Block {0}", l.toLocus().serializeShortForm());
        if (blockData instanceof Farmland) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Block {0} moistness {1}", l.toLocus().serializeShortForm(), ((Farmland)blockData).getMoisture());
            return ((Farmland)blockData).getMoisture() == this.level.get();
        }
        return false;
    }
}

