/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="jaylawl", name="wearing", aliases={"iswearing", "wielding", "iswielding"}, version="4.5", description="Tests what the target entity has equipped.")
public class WearingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="armorslot", aliases={"slot", "s"}, description="The item slot to check", defValue="HEAD")
    private EquipSlot slot;
    @MythicField(name="material", aliases={"mmitem", "m"}, description="A material or MythicItem name to check for")
    private BukkitItemStack item;
    private final Collection<BukkitItemStack> items;

    public WearingCondition(String line, MythicLineConfig mlc) {
        super(line);
        String s2 = mlc.getString(new String[]{"armorslot", "slot", "s"}, "HEAD", new String[0]).toUpperCase();
        String item = mlc.getString(new String[]{"material", "mat", "m", "mythicmobsitem", "mmitem", "mmi", "item"}, "DIRT", this.conditionVar);
        this.slot = EquipSlot.of(s2);
        this.items = BukkitItemStack.getMatches(item);
    }

    @Override
    public boolean check(AbstractEntity e) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking WEARING Condition...", new Object[0]);
        ItemStack slotitem = null;
        if (e.isLiving()) {
            switch (this.slot) {
                case HEAD: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getHelmet();
                    break;
                }
                case CHEST: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getChestplate();
                    break;
                }
                case LEGS: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getLeggings();
                    break;
                }
                case FEET: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getBoots();
                    break;
                }
                case HAND: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getItemInMainHand();
                    break;
                }
                case OFFHAND: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getItemInOffHand();
                    break;
                }
                case NONE: {
                    slotitem = null;
                    MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Invalid slot used: {0}", new Object[]{this.slot});
                }
            }
            slotitem = slotitem == null ? new ItemStack(Material.AIR) : slotitem;
            for (BukkitItemStack bukkitItemStack : this.items) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "| Check {0} == {1}", bukkitItemStack.toString(), slotitem.toString());
                if (!bukkitItemStack.isSimilar(slotitem)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "+ Items are similar, returning true", new Object[0]);
                return true;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "+ Items are not similar, returning false", new Object[0]);
        return false;
    }
}

