/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractFirework;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicFields;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.DyeColor;

@MythicMechanic(author="Ashijin", name="firework", aliases={"fireworks", "effect:firework", "effect:fireworks", "e:firework"}, description="Shoots a firework")
public class FireworkEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicFields(value={@MythicField(name="type", aliases={"t"}, description="The type of fireball to use.\nAvailable Types:\n    - BALL\n    - BALL_LARGE\n    - BURST\n    - CREEPER\n    - STAR\n", defValue="BALL"), @MythicField(name="power", aliases={"p", "duration", "d"}, description="The duration of the firework effect", defValue="2"), @MythicField(name="flicker", aliases={"f"}, description="Sets whether the firework should flicker", defValue="false"), @MythicField(name="trail", aliases={"tr"}, description="Sets whether the firework should have a trail", defValue="false"), @MythicField(name="colors", aliases={"color", "c"}, description="The primary colors of the firework", defValue="#FFFFFF"), @MythicField(name="fadedColors", aliases={"fcolors", "fc"}, description="The faded colors of the firework", defValue="#FFFFFF")})
    protected AbstractFirework firework;

    public FireworkEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        int b;
        int g2;
        int r;
        org.bukkit.Color color;
        DyeColor dColor;
        Color color2;
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String type = mlc.getString(new String[]{"type", "t"}, "BALL", new String[0]);
        int power = mlc.getInteger(new String[]{"power", "p", "duration", "d"}, 2);
        boolean flicker = mlc.getBoolean(new String[]{"flicker", "f"}, false);
        boolean trail = mlc.getBoolean(new String[]{"trail", "tr"}, false);
        String strColors = mlc.getString(new String[]{"colors", "color", "c"}, "#FFFFFF", new String[0]);
        String strFadeColors = mlc.getString(new String[]{"fadecolors", "fcolors", "fc"}, "#FFFFFF", new String[0]);
        ArrayList colors = Lists.newArrayList();
        ArrayList fadeColors = Lists.newArrayList();
        for (String colorCode : strColors.split(",")) {
            if (colorCode.startsWith("#")) {
                color2 = Color.decode(colorCode);
                colors.add(color2);
                continue;
            }
            dColor = DyeColor.valueOf((String)colorCode.toUpperCase());
            color = dColor.getFireworkColor();
            r = color.getRed();
            g2 = color.getGreen();
            b = color.getBlue();
            colors.add(new Color(r, g2, b));
        }
        for (String colorCode : strFadeColors.split(",")) {
            if (colorCode.startsWith("#")) {
                color2 = Color.decode(colorCode);
                fadeColors.add(color2);
                continue;
            }
            dColor = DyeColor.valueOf((String)colorCode.toUpperCase());
            color = dColor.getFireworkColor();
            r = color.getRed();
            g2 = color.getGreen();
            b = color.getBlue();
            fadeColors.add(new Color(r, g2, b));
        }
        this.firework = ((MythicBukkit)this.getPlugin()).getBootstrap().createFirework(type, power, colors, fadeColors, flicker, trail);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.firework.launch(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.firework.launch(data, target.getLocation());
        return SkillResult.SUCCESS;
    }
}

