/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="effect:particleequation", aliases={"effect:particleeq", "particleequation", "particleeq"})
public class ParticleEquationEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderString equation;
    private PlaceholderFloat boundX;
    private PlaceholderFloat boundY;
    private PlaceholderFloat boundZ;
    private PlaceholderFloat resolution;

    public ParticleEquationEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.amount = PlaceholderInt.of("1");
        this.equation = mlc.getPlaceholderString(new String[]{"equation", "eq"}, "0", new String[0]);
        this.boundX = mlc.getPlaceholderFloat(new String[]{"boundx", "bx"}, 1.0f, new String[0]);
        this.boundY = mlc.getPlaceholderFloat(new String[]{"boundy", "by"}, 1.0f, new String[0]);
        this.boundZ = mlc.getPlaceholderFloat(new String[]{"boundz", "bz"}, 1.0f, new String[0]);
        this.resolution = mlc.getPlaceholderFloat(new String[]{"resolution", "res"}, 0.1f, new String[0]);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    @Override
    protected void playEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        AbstractLocation location = target.clone();
        if (this.setYaw) {
            location.setYaw(this.yaw);
        }
        if (this.setPitch) {
            location.setPitch(this.pitch);
        }
        location.add(0.0, this.yOffset.get(data), 0.0);
        Expression expression = new ExpressionBuilder(this.equation.get(data)).variables("x", "y", "z").build();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double bX = x + (double)this.boundX.get(data);
        double bY = y + (double)this.boundY.get(data);
        double bZ = z + (double)this.boundZ.get(data);
        double maxX = x + bX;
        double maxY = y + bY;
        double maxZ = z + bZ;
        double minX = x - bX;
        double minY = y - bY;
        double minZ = z - bZ;
        float resolution = this.resolution.get(data);
        double sinYaw = Math.sin(Math.toRadians(this.yaw));
        double cosYaw = Math.cos(Math.toRadians(this.yaw));
        double sinPitch = Math.sin(Math.toRadians(this.pitch));
        double cosPitch = Math.cos(Math.toRadians(this.pitch));
        for (double xi = minX; xi <= maxX; xi += (double)resolution) {
            for (double yi = minY; yi <= maxY; yi += (double)resolution) {
                for (double zi = minZ; zi <= maxZ; zi += (double)resolution) {
                    double xLocal = cosYaw * (xi - x) - sinYaw * (yi - y);
                    double yLocal = sinYaw * sinPitch * (xi - x) + cosYaw * sinPitch * (yi - y) + cosPitch * (zi - z);
                    double zLocal = -sinYaw * cosPitch * (xi - x) - cosYaw * cosPitch * (yi - y) + sinPitch * (zi - z);
                    double value = expression.setVariable("x", xLocal).setVariable("y", yLocal).setVariable("z", zLocal).evaluate();
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "value {0} < {1}", value, Float.valueOf(resolution));
                    if (!(Math.abs(value) < (double)resolution)) continue;
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "send", new Object[0]);
                    double xGlobal = x + cosYaw * xLocal + sinYaw * yLocal;
                    double yGlobal = y - sinYaw * sinPitch * xLocal + cosYaw * sinPitch * yLocal + cosPitch * zLocal;
                    double zGlobal = z + sinYaw * cosPitch * xLocal + cosYaw * cosPitch * yLocal - sinPitch * zLocal;
                    location.setX(xGlobal);
                    location.setY(yGlobal);
                    location.setZ(zGlobal);
                    this.playParticleEffect(data, location, audience);
                }
            }
        }
    }

    protected void playDirectionalParticleEffect(SkillMetadata data, AbstractLocation origin, AbstractLocation target, AbstractLocation spawn, Collection<AbstractPlayer> audience) {
        AbstractVector direction = this.directionReversed ? origin.toVector().subtract(target.clone().toVector()).normalize() : target.toVector().subtract(origin.clone().toVector()).normalize();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.particleData == null) {
                this.particle.sendDirectional(audience, origin, this.pSpeed.get(data), 1, this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), direction);
            }
        } else {
            AbstractLocation ln = spawn.clone().add((double)(0.0f - this.xSpread.get(data)) + Numbers.randomDouble() * (double)this.xSpread.get(data) * 2.0, (double)this.vSpread.get(data) + Numbers.randomDouble() * (double)this.vSpread.get(data) * 2.0, (double)(0.0f - this.zSpread.get(data)) + Numbers.randomDouble() * (double)this.zSpread.get(data) * 2.0);
            new ParticleMaker.ParticlePacket(this.strParticle, direction, this.pSpeed.get(data), 1, true).send(ln, this.viewDistance);
        }
    }
}

