/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.VectorUtils;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="effect:particleorbital", aliases={"e:particleorbital", "particleorbital", "effect:particlecircle", "particlecircle", "e:particlecricle"})
public class ParticleOrbitalEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float radius;
    protected int points;
    protected int interval;
    protected int iterations;
    protected double velocity = 1.0;
    protected boolean rotate = false;
    protected boolean reversed = false;
    protected double xRotation = 0.0;
    protected double yRotation = 0.0;
    protected double zRotation = 0.0;
    protected double angularVelocityX = 0.015707963267948967;
    protected double angularVelocityY = 0.018479956785822312;
    protected double angularVelocityZ = 0.02026833970057931;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected double zOffset = 0.0;

    public ParticleOrbitalEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, 4.0f);
        this.points = mlc.getInteger(new String[]{"points", "p"}, 20);
        this.iterations = mlc.getInteger(new String[]{"ticks", "t"}, 100);
        this.interval = mlc.getInteger(new String[]{"interval", "in", "i"}, 10);
        this.xRotation = mlc.getDouble(new String[]{"rotationx", "rotx", "rx"}, 0.0);
        this.yRotation = mlc.getDouble(new String[]{"rotationy", "roty", "ry"}, 0.0);
        this.zRotation = mlc.getDouble(new String[]{"rotationz", "rotz", "rz"}, 0.0);
        this.xOffset = mlc.getDouble(new String[]{"offsetx", "offx", "ox"}, 0.0);
        this.yOffset = mlc.getDouble(new String[]{"offsety", "offy", "oy"}, 0.0);
        this.zOffset = mlc.getDouble(new String[]{"offsetz", "offz", "oz"}, 0.0);
        this.angularVelocityX = mlc.getDouble(new String[]{"angularvelocityx", "avx", "vx"}, 0.0);
        this.angularVelocityY = mlc.getDouble(new String[]{"angularvelocityy", "avy", "vy"}, 0.0);
        this.angularVelocityZ = mlc.getDouble(new String[]{"angularvelocityz", "avz", "vz"}, 0.0);
        this.angularVelocityX = this.angularVelocityX == 0.0 ? 0.0 : Math.PI / this.angularVelocityX;
        this.angularVelocityY = this.angularVelocityY == 0.0 ? 0.0 : Math.PI / this.angularVelocityY;
        this.angularVelocityZ = this.angularVelocityZ == 0.0 ? 0.0 : Math.PI / this.angularVelocityZ;
        this.rotate = mlc.getBoolean(new String[]{"rotate"}, this.angularVelocityX > 0.0 || this.angularVelocityY > 0.0 || this.angularVelocityZ > 0.0);
        this.reversed = mlc.getBoolean(new String[]{"reversed", "reverse"}, false);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(data, target);
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable {
        private SkillMetadata data;
        private Optional<AbstractEntity> entity = Optional.empty();
        private Optional<AbstractLocation> location = Optional.empty();
        private int iteration = 0;
        private int step = 0;
        private Task task;

        public Animator(SkillMetadata data, AbstractEntity entity) {
            this.data = data;
            this.entity = Optional.of(entity);
            this.task = Schedulers.async().runRepeating(this, 0L, (long)ParticleOrbitalEffect.this.interval);
        }

        public Animator(SkillMetadata data, AbstractLocation location) {
            this.data = data;
            this.location = Optional.of(location);
            this.task = Schedulers.async().runRepeating(this, 0L, (long)ParticleOrbitalEffect.this.interval);
        }

        public AbstractLocation getLocation() {
            if (this.entity.isPresent()) {
                return this.entity.get().getLocation().add(ParticleOrbitalEffect.this.xOffset, ParticleOrbitalEffect.this.yOffset, ParticleOrbitalEffect.this.zOffset);
            }
            return this.location.get().clone().add(ParticleOrbitalEffect.this.xOffset, ParticleOrbitalEffect.this.yOffset, ParticleOrbitalEffect.this.zOffset);
        }

        @Override
        public void run() {
            AbstractLocation location = this.getLocation();
            double inc = Math.PI * 2 / (double)ParticleOrbitalEffect.this.points;
            double angle = (double)this.step * inc;
            AbstractVector v = new AbstractVector();
            v.setX(Math.cos(angle) * (double)ParticleOrbitalEffect.this.radius);
            v.setZ(Math.sin(angle) * (double)ParticleOrbitalEffect.this.radius);
            VectorUtils.rotateVector(v, ParticleOrbitalEffect.this.xRotation, ParticleOrbitalEffect.this.yRotation, ParticleOrbitalEffect.this.zRotation);
            if (ParticleOrbitalEffect.this.rotate) {
                VectorUtils.rotateVector(v, ParticleOrbitalEffect.this.angularVelocityX * (double)this.step, ParticleOrbitalEffect.this.angularVelocityY * (double)this.step, ParticleOrbitalEffect.this.angularVelocityZ * (double)this.step);
            }
            AbstractLocation loc = location.add(v);
            Collection<AbstractPlayer> audience = ParticleOrbitalEffect.this.audience.get(this.data, this.data.getCaster().getEntity());
            ParticleOrbitalEffect.this.playParticleEffect(this.data, loc, audience);
            this.step = ParticleOrbitalEffect.this.reversed ? --this.step : ++this.step;
            if (++this.iteration * ParticleOrbitalEffect.this.interval >= ParticleOrbitalEffect.this.iterations) {
                this.task.terminate();
            }
        }
    }
}

