/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="settonguetarget", aliases={"tonguetarget"}, description="Sets the casting frog's tongue to target the given entity")
public class SetTongueTargetMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public SetTongueTargetMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        LivingEntity caster = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        Entity tar = target.getBukkitEntity();
        if (caster instanceof Frog) {
            Frog frog = (Frog)caster;
            frog.setTongueTarget(tar);
            return SkillResult.SUCCESS;
        }
        return SkillResult.INVALID_CONFIG;
    }
}

