/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class MEGBullet
extends ProjectileBullet {
    @MythicField(name="bulletModel", description="The MEG model to use for the bullet.")
    protected String bulletModel = null;
    @MythicField(name="bulletColor", description="The color of the bullet type")
    protected String bulletColor = null;
    @MythicField(name="bulletEnchanted", aliases={"enchanted"}, description="Whether the item should be enchanted or not", defValue="false")
    protected boolean bulletEnchanted;

    public MEGBullet(ProjectileBulletType type, SkillMechanic projectile, MythicLineConfig config) {
        super(type, projectile, config);
        String strBulletMaterial = config.getString(new String[]{"bulletmaterial", "material", "mat"}, "STONE", new String[0]);
        this.bulletModel = config.getString(new String[]{"bulletmodel", "model"}, null, new String[0]);
        this.bulletColor = config.getString(new String[]{"bulletcolor"}, null, new String[0]);
        this.bulletEnchanted = config.getBoolean(new String[]{"bulletEnchanted", "enchanted"}, false);
        this.getPlugin().getSkillManager().queueAfterLoad(() -> {
            Optional<AbstractModelEngineSupport> support = this.getPlugin().getCompatibility().getModelEngine();
            if (!support.isPresent()) {
                MythicLogger.errorMechanicConfig(projectile, config, "MEG Bullets are not usable without ModelEngine");
            }
        });
    }

    @Override
    public ProjectileBullet.BulletTracker create(ProjectileBulletableTracker projectile, AbstractEntity target) {
        return new MEGBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    public class MEGBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected AbstractEntity bullet;

        public MEGBulletTracker(ProjectileBulletableTracker projectile, AbstractEntity target) {
            super(MEGBullet.this, projectile, target);
            Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getEntity() != null).filter(event -> event.getEntity().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> projectile.terminate()).bindWith(projectile);
        }

        @Override
        public void spawn(AbstractLocation start) {
            ArmorStand armorStand;
            Optional<AbstractModelEngineSupport> support = MEGBullet.this.getPlugin().getCompatibility().getModelEngine();
            if (!support.isPresent()) {
                MythicLogger.errorMechanicConfig(MEGBullet.this.getProjectileMechanic(), MEGBullet.this.getConfig(), "MEG Bullets are not usable without ModelEngine");
                return;
            }
            AbstractLocation l = this.getProjectile().getCurrentLocation().clone().subtract(0.0, 1.4375, 0.0);
            Location location = BukkitAdapter.adapt(l);
            if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND, CreatureSpawnEvent.SpawnReason.CUSTOM, entity -> {
                    this.bullet = BukkitAdapter.adapt(entity);
                    ArmorStand as = (ArmorStand)entity;
                    as.setInvisible(true);
                    as.setAI(true);
                    as.setTicksLived(Integer.MAX_VALUE);
                    as.setMarker(true);
                    as.setGravity(false);
                    as.setRemoveWhenFarAway(true);
                    as.setInvulnerable(true);
                });
            } else {
                armorStand = (ArmorStand)MEGBullet.this.getPlugin().getVolatileCodeHandler().getWorldHandler().spawnInvisibleArmorStand(location);
                this.bullet = BukkitAdapter.adapt((Entity)armorStand);
                armorStand.setInvisible(true);
                armorStand.setAI(true);
                armorStand.setTicksLived(Integer.MAX_VALUE);
                armorStand.setGravity(false);
                armorStand.setRemoveWhenFarAway(true);
                armorStand.setInvulnerable(true);
            }
            if (support.get().createMobModel(this.bullet, MEGBullet.this.bulletModel) == null) {
                MythicLogger.errorMechanicConfig(MEGBullet.this.getProjectileMechanic(), MEGBullet.this.getConfig(), "MEG Bullet is an invalid model, or MEG is out of date");
                return;
            }
            if (MEGBullet.this.bulletColor != null) {
                // empty if block
            }
            Projectile.BULLET_ENTITIES.add(this.bullet);
            MEGBullet.this.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
            if (this.getProjectile().hasTerminated()) {
                armorStand.remove();
            }
        }

        @Override
        public void tick(AbstractLocation origin) {
            Projectile projectileMechanic;
            if (this.bullet == null) {
                return;
            }
            if (!(this.bullet.getBukkitEntity() instanceof ArmorStand)) {
                return;
            }
            ArmorStand stand = (ArmorStand)this.bullet.getBukkitEntity();
            SkillMechanic skillMechanic = MEGBullet.this.getProjectileMechanic();
            double forwardOffset = skillMechanic instanceof Projectile ? ((projectileMechanic = (Projectile)skillMechanic).getTickInterpolation() == 0 ? MEGBullet.this.bulletForwardOffset : MEGBullet.this.bulletForwardOffset * (double)projectileMechanic.getTickInterpolation()) : MEGBullet.this.bulletForwardOffset;
            AbstractLocation currentLocation = this.getProjectile().getCurrentLocation().clone();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity().clone().multiply(forwardOffset);
            Location to = BukkitAdapter.adapt(currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(currentVelocity).normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            double pitch = Math.atan2(delta.getY(), len);
            stand.setHeadPose(new EulerAngle(-pitch, 0.0, 0.0));
            Location loc = to.clone().add(delta).subtract(0.0, 1.4375, 0.0);
            loc.setYaw((float)Math.toDegrees(-yaw));
            stand.teleport(loc);
        }

        @Override
        public void despawn() {
            this.bullet.remove();
            Projectile.BULLET_ENTITIES.remove(this.bullet);
        }
    }
}

