/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats.types;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.stats.TriggerModifyingStat;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.triggers.meta.DamagedMetadata;
import io.lumine.mythic.core.skills.triggers.meta.EntityAttackMetadata;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.util.List;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class DamageModifierStat
extends StatType
implements TriggerModifyingStat {
    private static final StringProp TYPE = Property.String(Scope.STATS, "DamageType", null);
    private static final StringProp FORMULA = Property.String(Scope.STATS, "DamageFormula", null);
    private static final StringListProp CONDITIONS = Property.StringList(Scope.STATS, "Conditions");
    private String damageType;
    private Expression expression;
    private List<SkillCondition> conditions = Lists.newArrayList();

    public DamageModifierStat(Object scope, String key) {
        super(scope, key);
    }

    @Override
    public void initialize(StatExecutor manager) {
        super.initialize(manager);
        this.damageType = (String)TYPE.fget(this.getScope(), this);
        List conditions = (List)CONDITIONS.fget(this.getScope(), this);
        for (String cond : conditions) {
            SkillCondition c = MythicBukkit.inst().getSkillManager().getCondition(cond);
            if (c instanceof InvalidCondition) continue;
            this.conditions.add(c);
        }
        String formula = (String)FORMULA.fget(this.getScope(), this);
        try {
            ExpressionBuilder builder = new ExpressionBuilder(formula).operator(Operators.operators).functions(Functions.functions).variables("d", "v");
            this.expression = builder.build();
        }
        catch (Exception ex) {
            MythicLogger.error("X Invalid DamageModifier formula defined: " + formula);
            ex.printStackTrace();
            this.expression = new ExpressionBuilder("0").build();
            return;
        }
    }

    @Override
    public void processTrigger(SkillMetadata skillMetadata, SkillTriggerMetadata triggerMetadata, StatRegistry statRegistry, double value) {
        if (triggerMetadata instanceof EntityAttackMetadata) {
            EntityAttackMetadata attackMetadata = (EntityAttackMetadata)triggerMetadata;
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateCaster(skillMetadata)) continue;
                return;
            }
            if (this.damageType == null) {
                double damage = attackMetadata.getDamage();
                double newDamage = this.expression.setVariable("d", damage).setVariable("v", value).evaluate();
                attackMetadata.setDamage(newDamage);
            } else {
                if (!attackMetadata.getBonusDamage().containsKey(this.damageType)) {
                    return;
                }
                Double damage = attackMetadata.getBonusDamage().computeIfAbsent(this.damageType, d -> value);
                double newDamage = this.expression.setVariable("d", damage).setVariable("v", value).evaluate();
                attackMetadata.getBonusDamage().put(this.damageType, newDamage);
            }
        } else if (triggerMetadata instanceof DamagedMetadata) {
            DamagedMetadata damagedMetadata = (DamagedMetadata)triggerMetadata;
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateCaster(skillMetadata)) continue;
                return;
            }
            if (this.damageType == null) {
                double damage = damagedMetadata.getDamage();
                double newDamage = this.expression.setVariable("d", damage).setVariable("v", value).evaluate();
                damagedMetadata.setDamage(newDamage);
            } else {
                if (!damagedMetadata.getBonusDamage().containsKey(this.damageType)) {
                    return;
                }
                Double damage = damagedMetadata.getBonusDamage().computeIfAbsent(this.damageType, d -> value);
                double newDamage = this.expression.setVariable("d", damage).setVariable("v", value).evaluate();
                damagedMetadata.getBonusDamage().put(this.damageType, newDamage);
            }
        }
    }
}

