/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="projectileforward", aliases={""}, description="Targets a point in front of the casting projectile")
public class ProjectileForwardTargeter
extends ILocationSelector {
    protected PlaceholderDouble forward;
    protected PlaceholderFloat rotate;
    protected boolean rotated = false;

    public ProjectileForwardTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.forward = mlc.getPlaceholderDouble(new String[]{"forward", "f", "amount", "a"}, 1.0, new String[0]);
        this.rotate = mlc.getPlaceholderFloat(new String[]{"rotate", "rot"}, 0.0f, new String[0]);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        IParentSkill iParentSkill = data.getCallingEvent();
        if (!(iParentSkill instanceof Projectile.ProjectileTracker)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "ProjectileForwardTargeter called by non-projectile, skipping", new Object[0]);
            return targets;
        }
        Projectile.ProjectileTracker tracker = (Projectile.ProjectileTracker)iParentSkill;
        AbstractLocation location = tracker.getCurrentLocation().clone();
        AbstractVector direction = tracker.getCurrentVelocity().clone();
        float rotate = this.rotate.get(data);
        double forward = this.forward.get(data);
        if (rotate != 0.0f) {
            location.add(direction.rotate(rotate).normalize().multiply(forward));
        } else {
            location.add(direction.normalize().multiply(forward));
        }
        targets.add(this.mutate(data, location));
        return targets;
    }
}

