/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Phil", name="randomLocationsNearCaster", aliases={"RLNC", "randomLocations"}, description="Targets random locations near the caster")
public class RandomLocationsTargeter
extends ILocationSelector {
    private PlaceholderInt amount;
    private int maxRadius;
    private int minRadius;
    private int minRadiusSq;
    private int spacing;
    private int spacingSq;

    public RandomLocationsTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 5, new String[0]);
        this.maxRadius = mlc.getInteger(new String[]{"radius", "r", "maxradius", "maxr"}, 5);
        this.minRadius = mlc.getInteger(new String[]{"minradius", "minr"}, 0);
        this.spacing = mlc.getInteger(new String[]{"spacing", "s"}, 0);
        this.minRadiusSq = this.minRadius * this.minRadius;
        this.spacingSq = this.spacing * this.spacing;
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        int amount = this.amount.get(data);
        int amountSq = amount * amount;
        AbstractLocation loc = data.getCaster().getLocation();
        int i = 0;
        int j = 0;
        while (i < amount && j < amountSq) {
            ++j;
            MythicBukkit.inst().getMobManager();
            AbstractLocation l = MobExecutor.findSafeSpawnLocation(loc, this.maxRadius, 1.0, 1, true, false);
            if (this.minRadius > 0 && l.distanceSquared(loc) < (double)this.minRadiusSq) continue;
            if (this.spacing > 0) {
                boolean bad = false;
                for (AbstractLocation l2 : targets) {
                    if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                    bad = true;
                    break;
                }
                if (bad) continue;
            }
            targets.add(this.mutate(data, l));
            ++i;
        }
        return targets;
    }
}

