/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.javassist;

import java.io.DataOutputStream;
import java.io.IOException;
import pers.neige.neigeitems.javassist.CannotCompileException;
import pers.neige.neigeitems.javassist.ClassPool;
import pers.neige.neigeitems.javassist.CtClass;
import pers.neige.neigeitems.javassist.CtClassType;
import pers.neige.neigeitems.javassist.CtConstructor;
import pers.neige.neigeitems.javassist.CtNewConstructor;
import pers.neige.neigeitems.javassist.Modifier;
import pers.neige.neigeitems.javassist.NotFoundException;
import pers.neige.neigeitems.javassist.bytecode.ClassFile;

class CtNewClass
extends CtClassType {
    protected boolean hasConstructor;

    CtNewClass(String name2, ClassPool cp, boolean isInterface, CtClass superclass2) {
        super(name2, cp);
        this.wasChanged = true;
        String superName = isInterface || superclass2 == null ? null : superclass2.getName();
        this.classfile = new ClassFile(isInterface, name2, superName);
        if (isInterface && superclass2 != null) {
            this.classfile.setInterfaces(new String[]{superclass2.getName()});
        }
        this.setModifiers(Modifier.setPublic(this.getModifiers()));
        this.hasConstructor = isInterface;
    }

    @Override
    protected void extendToString(StringBuffer buffer) {
        if (this.hasConstructor) {
            buffer.append("hasConstructor ");
        }
        super.extendToString(buffer);
    }

    @Override
    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.hasConstructor = true;
        super.addConstructor(c);
    }

    @Override
    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        if (!this.hasConstructor) {
            try {
                this.inheritAllConstructors();
                this.hasConstructor = true;
            }
            catch (NotFoundException e) {
                throw new CannotCompileException(e);
            }
        }
        super.toBytecode(out);
    }

    public void inheritAllConstructors() throws CannotCompileException, NotFoundException {
        CtClass superclazz = this.getSuperclass();
        CtConstructor[] cs = superclazz.getDeclaredConstructors();
        int n = 0;
        for (int i = 0; i < cs.length; ++i) {
            CtConstructor c = cs[i];
            int mod = c.getModifiers();
            if (!this.isInheritable(mod, superclazz)) continue;
            CtConstructor cons = CtNewConstructor.make(c.getParameterTypes(), c.getExceptionTypes(), this);
            cons.setModifiers(mod & 7);
            this.addConstructor(cons);
            ++n;
        }
        if (n < 1) {
            throw new CannotCompileException("no inheritable constructor in " + superclazz.getName());
        }
    }

    private boolean isInheritable(int mod, CtClass superclazz) {
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isPackage(mod)) {
            String pname = this.getPackageName();
            String pname2 = superclazz.getPackageName();
            if (pname == null) {
                return pname2 == null;
            }
            return pname.equals(pname2);
        }
        return true;
    }
}

