/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import pers.neige.neigeitems.javassist.bytecode.AnnotationDefaultAttribute;
import pers.neige.neigeitems.javassist.bytecode.AnnotationsAttribute;
import pers.neige.neigeitems.javassist.bytecode.BootstrapMethodsAttribute;
import pers.neige.neigeitems.javassist.bytecode.CodeAttribute;
import pers.neige.neigeitems.javassist.bytecode.ConstPool;
import pers.neige.neigeitems.javassist.bytecode.ConstantAttribute;
import pers.neige.neigeitems.javassist.bytecode.DeprecatedAttribute;
import pers.neige.neigeitems.javassist.bytecode.EnclosingMethodAttribute;
import pers.neige.neigeitems.javassist.bytecode.ExceptionsAttribute;
import pers.neige.neigeitems.javassist.bytecode.InnerClassesAttribute;
import pers.neige.neigeitems.javassist.bytecode.LineNumberAttribute;
import pers.neige.neigeitems.javassist.bytecode.LocalVariableAttribute;
import pers.neige.neigeitems.javassist.bytecode.LocalVariableTypeAttribute;
import pers.neige.neigeitems.javassist.bytecode.MethodParametersAttribute;
import pers.neige.neigeitems.javassist.bytecode.ParameterAnnotationsAttribute;
import pers.neige.neigeitems.javassist.bytecode.SignatureAttribute;
import pers.neige.neigeitems.javassist.bytecode.SourceFileAttribute;
import pers.neige.neigeitems.javassist.bytecode.StackMap;
import pers.neige.neigeitems.javassist.bytecode.StackMapTable;
import pers.neige.neigeitems.javassist.bytecode.SyntheticAttribute;
import pers.neige.neigeitems.javassist.bytecode.TypeAnnotationsAttribute;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool cp, int attrname, byte[] attrinfo) {
        this.constPool = cp;
        this.name = attrname;
        this.info = attrinfo;
    }

    protected AttributeInfo(ConstPool cp, String attrname) {
        this(cp, attrname, (byte[])null);
    }

    public AttributeInfo(ConstPool cp, String attrname, byte[] attrinfo) {
        this(cp, cp.addUtf8Info(attrname), attrinfo);
    }

    protected AttributeInfo(ConstPool cp, int n, DataInputStream in) throws IOException {
        this.constPool = cp;
        this.name = n;
        int len = in.readInt();
        this.info = new byte[len];
        if (len > 0) {
            in.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool cp, DataInputStream in) throws IOException {
        int name2 = in.readUnsignedShort();
        String nameStr = cp.getUtf8Info(name2);
        char first = nameStr.charAt(0);
        if (first < 'M') {
            if (first < 'E') {
                if (nameStr.equals("AnnotationDefault")) {
                    return new AnnotationDefaultAttribute(cp, name2, in);
                }
                if (nameStr.equals("BootstrapMethods")) {
                    return new BootstrapMethodsAttribute(cp, name2, in);
                }
                if (nameStr.equals("Code")) {
                    return new CodeAttribute(cp, name2, in);
                }
                if (nameStr.equals("ConstantValue")) {
                    return new ConstantAttribute(cp, name2, in);
                }
                if (nameStr.equals("Deprecated")) {
                    return new DeprecatedAttribute(cp, name2, in);
                }
            } else {
                if (nameStr.equals("EnclosingMethod")) {
                    return new EnclosingMethodAttribute(cp, name2, in);
                }
                if (nameStr.equals("Exceptions")) {
                    return new ExceptionsAttribute(cp, name2, in);
                }
                if (nameStr.equals("InnerClasses")) {
                    return new InnerClassesAttribute(cp, name2, in);
                }
                if (nameStr.equals("LineNumberTable")) {
                    return new LineNumberAttribute(cp, name2, in);
                }
                if (nameStr.equals("LocalVariableTable")) {
                    return new LocalVariableAttribute(cp, name2, in);
                }
                if (nameStr.equals("LocalVariableTypeTable")) {
                    return new LocalVariableTypeAttribute(cp, name2, in);
                }
            }
        } else if (first < 'S') {
            if (nameStr.equals("MethodParameters")) {
                return new MethodParametersAttribute(cp, name2, in);
            }
            if (nameStr.equals("RuntimeVisibleAnnotations") || nameStr.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(cp, name2, in);
            }
            if (nameStr.equals("RuntimeVisibleParameterAnnotations") || nameStr.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(cp, name2, in);
            }
            if (nameStr.equals("RuntimeVisibleTypeAnnotations") || nameStr.equals("RuntimeInvisibleTypeAnnotations")) {
                return new TypeAnnotationsAttribute(cp, name2, in);
            }
        } else {
            if (nameStr.equals("Signature")) {
                return new SignatureAttribute(cp, name2, in);
            }
            if (nameStr.equals("SourceFile")) {
                return new SourceFileAttribute(cp, name2, in);
            }
            if (nameStr.equals("Synthetic")) {
                return new SyntheticAttribute(cp, name2, in);
            }
            if (nameStr.equals("StackMap")) {
                return new StackMap(cp, name2, in);
            }
            if (nameStr.equals("StackMapTable")) {
                return new StackMapTable(cp, name2, in);
            }
        }
        return new AttributeInfo(cp, name2, in);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] newinfo) {
        this.info = newinfo;
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        int s = this.info.length;
        byte[] srcInfo = this.info;
        byte[] newInfo = new byte[s];
        for (int i = 0; i < s; ++i) {
            newInfo[i] = srcInfo[i];
        }
        return new AttributeInfo(newCp, this.getName(), newInfo);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.info.length);
        if (this.info.length > 0) {
            out.write(this.info);
        }
    }

    static int getLength(ArrayList list2) {
        int size = 0;
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list2.get(i);
            size += attr.length();
        }
        return size;
    }

    static AttributeInfo lookup(ArrayList list2, String name2) {
        if (list2 == null) {
            return null;
        }
        ListIterator iterator = list2.listIterator();
        while (iterator.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator.next();
            if (!ai.getName().equals(name2)) continue;
            return ai;
        }
        return null;
    }

    static synchronized void remove(ArrayList list2, String name2) {
        if (list2 == null) {
            return;
        }
        ListIterator iterator = list2.listIterator();
        while (iterator.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator.next();
            if (!ai.getName().equals(name2)) continue;
            iterator.remove();
        }
    }

    static void writeAll(ArrayList list2, DataOutputStream out) throws IOException {
        if (list2 == null) {
            return;
        }
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list2.get(i);
            attr.write(out);
        }
    }

    static ArrayList copyAll(ArrayList list2, ConstPool cp) {
        if (list2 == null) {
            return null;
        }
        ArrayList<AttributeInfo> newList = new ArrayList<AttributeInfo>();
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list2.get(i);
            newList.add(attr.copy(cp, null));
        }
        return newList;
    }

    void renameClass(String oldname, String newname) {
    }

    void renameClass(Map classnames) {
    }

    static void renameClass(List attributes, String oldname, String newname) {
        for (AttributeInfo ai : attributes) {
            ai.renameClass(oldname, newname);
        }
    }

    static void renameClass(List attributes, Map classnames) {
        for (AttributeInfo ai : attributes) {
            ai.renameClass(classnames);
        }
    }

    void getRefClasses(Map classnames) {
    }

    static void getRefClasses(List attributes, Map classnames) {
        for (AttributeInfo ai : attributes) {
            ai.getRefClasses(classnames);
        }
    }
}

