/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import pers.neige.neigeitems.javassist.ClassPool;
import pers.neige.neigeitems.javassist.bytecode.ConstPool;
import pers.neige.neigeitems.javassist.bytecode.annotation.AnnotationsWriter;
import pers.neige.neigeitems.javassist.bytecode.annotation.MemberValue;
import pers.neige.neigeitems.javassist.bytecode.annotation.MemberValueVisitor;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int index, ConstPool cp) {
        super('I', cp);
        this.valueIndex = index;
    }

    public IntegerMemberValue(ConstPool cp, int value2) {
        super('I', cp);
        this.setValue(value2);
    }

    public IntegerMemberValue(ConstPool cp) {
        super('I', cp);
        this.setValue(0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Integer(this.getValue());
    }

    @Override
    Class getType(ClassLoader cl) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitIntegerMemberValue(this);
    }
}

