/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.manager;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin1720.collections.CollectionsKt;
import kotlin1720.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.neige.neigeitems.item.ItemPack;
import pers.neige.neigeitems.utils.ConfigUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lpers/neige/neigeitems/manager/ItemPackManager;", "", "()V", "itemPackIds", "", "", "kotlin1720.jvm.PlatformType", "getItemPackIds", "()Ljava/util/List;", "itemPackIdsRaw", "getItemPackIdsRaw", "itemPacks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lpers/neige/neigeitems/item/ItemPack;", "getItemPacks", "()Ljava/util/concurrent/ConcurrentHashMap;", "getItemPack", "id", "loadItemPacks", "", "reload", "NeigeItems"})
public final class ItemPackManager {
    @NotNull
    public static final ItemPackManager INSTANCE = new ItemPackManager();
    @NotNull
    private static final ConcurrentHashMap<String, ItemPack> itemPacks = new ConcurrentHashMap();

    private ItemPackManager() {
    }

    @NotNull
    public final ConcurrentHashMap<String, ItemPack> getItemPacks() {
        return itemPacks;
    }

    @NotNull
    public final List<String> getItemPackIds() {
        Set set = itemPacks.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"itemPacks.keys");
        return CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)set));
    }

    @NotNull
    public final List<String> getItemPackIdsRaw() {
        Set set = itemPacks.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"itemPacks.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    @Nullable
    public final ItemPack getItemPack(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return itemPacks.get(id);
    }

    private final void loadItemPacks() {
        for (File file : ConfigUtils.getAllFiles("ItemPacks")) {
            YamlConfiguration config;
            Intrinsics.checkNotNullExpressionValue((Object)YamlConfiguration.loadConfiguration((File)file), (String)"loadConfiguration(file)");
            Set set = config.getKeys(false);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"config.getKeys(false)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String id = (String)element$iv;
                boolean bl = false;
                ConfigurationSection configSection = config.getConfigurationSection(id);
                if (configSection == null) continue;
                boolean bl2 = false;
                Map map = itemPacks;
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                map.put(id, new ItemPack(id, configSection));
            }
        }
    }

    public final void reload() {
        itemPacks.clear();
        this.loadItemPacks();
    }

    static {
        INSTANCE.loadItemPacks();
    }
}

