/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin1720.io.FilesKt;
import kotlin1720.jvm.internal.Intrinsics;
import kotlin1720.text.StringsKt;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import pers.neige.neigeitems.manager.HookerManager;
import pers.neige.neigeitems.manager.SectionManager;
import pers.neige.neigeitems.script.CompiledScript;
import pers.neige.neigeitems.section.SectionParser;
import pers.neige.neigeitems.section.impl.CalculationParser;
import pers.neige.neigeitems.section.impl.CheckParser;
import pers.neige.neigeitems.section.impl.FastCalcParser;
import pers.neige.neigeitems.section.impl.GaussianParser;
import pers.neige.neigeitems.section.impl.GradientParser;
import pers.neige.neigeitems.section.impl.InheritParser;
import pers.neige.neigeitems.section.impl.JavascriptParser;
import pers.neige.neigeitems.section.impl.JoinParser;
import pers.neige.neigeitems.section.impl.NumberParser;
import pers.neige.neigeitems.section.impl.PapiParser;
import pers.neige.neigeitems.section.impl.RepeatParser;
import pers.neige.neigeitems.section.impl.StringsParser;
import pers.neige.neigeitems.section.impl.WeightDeclareParser;
import pers.neige.neigeitems.section.impl.WeightJoinParser;
import pers.neige.neigeitems.section.impl.WeightParser;
import pers.neige.neigeitems.section.impl.WhenParser;
import pers.neige.neigeitems.taboolib.common.LifeCycle;
import pers.neige.neigeitems.taboolib.common.platform.Awake;
import pers.neige.neigeitems.taboolib.common.platform.function.ExecutorKt;
import pers.neige.neigeitems.utils.ConfigUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0018J\b\u0010\u001e\u001a\u00020\u0018H\u0003R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR-\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lpers/neige/neigeitems/manager/SectionManager;", "", "()V", "files", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "getFiles", "()Ljava/util/ArrayList;", "globalSectionMap", "Ljava/util/HashMap;", "", "Lorg/bukkit/configuration/ConfigurationSection;", "Lkotlin/collections/HashMap;", "getGlobalSectionMap", "()Ljava/util/HashMap;", "globalSections", "getGlobalSections", "sectionParsers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lpers/neige/neigeitems/section/SectionParser;", "getSectionParsers", "()Ljava/util/concurrent/ConcurrentHashMap;", "loadBasicParser", "", "loadCustomSections", "loadGlobalSections", "loadParser", "sectionParser", "reload", "update", "NeigeItems"})
public final class SectionManager {
    @NotNull
    public static final SectionManager INSTANCE = new SectionManager();
    @NotNull
    private static final ArrayList<File> files = ConfigUtils.getAllFiles("GlobalSections");
    @NotNull
    private static final HashMap<String, ConfigurationSection> globalSectionMap = new HashMap();
    @NotNull
    private static final HashMap<String, Object> globalSections = new HashMap();
    @NotNull
    private static final ConcurrentHashMap<String, SectionParser> sectionParsers = new ConcurrentHashMap();

    private SectionManager() {
    }

    @NotNull
    public final ArrayList<File> getFiles() {
        return files;
    }

    @NotNull
    public final HashMap<String, ConfigurationSection> getGlobalSectionMap() {
        return globalSectionMap;
    }

    @NotNull
    public final HashMap<String, Object> getGlobalSections() {
        return globalSections;
    }

    @NotNull
    public final ConcurrentHashMap<String, SectionParser> getSectionParsers() {
        return sectionParsers;
    }

    public final void loadParser(@NotNull SectionParser sectionParser) {
        Intrinsics.checkNotNullParameter((Object)sectionParser, (String)"sectionParser");
        ((Map)sectionParsers).put(sectionParser.getId(), sectionParser);
    }

    public final void reload() {
        files.clear();
        files.addAll((Collection<File>)ConfigUtils.getAllFiles("GlobalSections"));
        globalSectionMap.clear();
        globalSections.clear();
        sectionParsers.clear();
        this.loadGlobalSections();
        this.loadBasicParser();
        this.loadCustomSections();
    }

    @Awake(value=LifeCycle.ACTIVE)
    private final void update() {
        ExecutorKt.submit$default(false, false, 60L, 0L, null, update.1.INSTANCE, 27, null);
    }

    private final void loadGlobalSections() {
        for (File file : files) {
            if (HookerManager.INSTANCE.getPapiHooker() != null) {
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                String text = FilesKt.readText$default((File)file, null, (int)1, null);
                if (HookerManager.INSTANCE.getPapiHooker().hasPapi(text)) {
                    FilesKt.writeText$default((File)file, (String)HookerManager.INSTANCE.getPapiHooker().toSection(text), null, (int)2, null);
                }
            }
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            String fileName = StringsKt.replace$default((String)string, (String)("plugins" + File.separator + "NeigeItems" + File.separator + "GlobalSections" + File.separator), (String)"", (boolean)false, (int)4, null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            YamlConfiguration config = ConfigUtils.loadConfiguration(file);
            ((Map)globalSectionMap).put(fileName, config);
            for (String key2 : config.getKeys(false)) {
                Object it;
                if (config.get(key2) == null) continue;
                boolean bl = false;
                Map map = globalSections;
                Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"key");
                map.put(key2, it);
            }
        }
    }

    private final void loadBasicParser() {
        CalculationParser.INSTANCE.register();
        CheckParser.INSTANCE.register();
        FastCalcParser.INSTANCE.register();
        GaussianParser.INSTANCE.register();
        GradientParser.INSTANCE.register();
        InheritParser.INSTANCE.register();
        JavascriptParser.INSTANCE.register();
        JoinParser.INSTANCE.register();
        NumberParser.INSTANCE.register();
        PapiParser.INSTANCE.register();
        RepeatParser.INSTANCE.register();
        StringsParser.INSTANCE.register();
        WeightDeclareParser.INSTANCE.register();
        WeightJoinParser.INSTANCE.register();
        WeightParser.INSTANCE.register();
        WhenParser.INSTANCE.register();
    }

    private final void loadCustomSections() {
        for (File file : ConfigUtils.getAllFiles("CustomSections")) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                new CompiledScript(file).invoke("main", null, new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        INSTANCE.loadGlobalSections();
        INSTANCE.loadBasicParser();
        INSTANCE.loadCustomSections();
    }
}

