/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.maven;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin1720.collections.ArraysKt;
import kotlin1720.io.CloseableKt;
import kotlin1720.jvm.functions.Function1;
import kotlin1720.jvm.internal.Intrinsics;
import kotlin1720.text.Charsets;
import kotlin1720.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pers.neige.neigeitems.maven.JarLoader;
import pers.neige.neigeitems.maven.MavenDependency;
import pers.neige.neigeitems.taboolib.common.env.RuntimeDependencies;
import pers.neige.neigeitems.taboolib.common.env.RuntimeDependency;

@RuntimeDependencies(value={@RuntimeDependency(value="!org.apache.maven:maven-model:3.9.1", test="!org.apache.maven.model.Dependency")})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tB-\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0003H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0003*\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpers/neige/neigeitems/maven/MavenDependency;", "", "libPath", "", "groupId", "artifactId", "version", "repos", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "repo", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "[Ljava/lang/String;", "getFile", "Ljava/io/File;", "extension", "getFileAndCheck", "load", "", "toSha1", "NeigeItems"})
public final class MavenDependency {
    @NotNull
    private final String libPath;
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private final String version;
    @NotNull
    private final String[] repos;

    public MavenDependency(@NotNull String libPath, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String[] repos) {
        Intrinsics.checkNotNullParameter((Object)libPath, (String)"libPath");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)repos, (String)"repos");
        this.libPath = libPath;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.repos = repos;
    }

    public MavenDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String[] repos) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)repos, (String)"repos");
        this.libPath = "libs";
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.repos = repos;
    }

    public MavenDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String repo) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        this.libPath = "libs";
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        String[] stringArray = new String[]{repo};
        this.repos = stringArray;
    }

    public MavenDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.libPath = "libs";
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        String[] stringArray = new String[]{"https://maven.aliyun.com/repository/public", "https://repo.maven.apache.org/maven2"};
        this.repos = stringArray;
    }

    public final void load() {
        JarLoader.load(MavenDependency.getFileAndCheck$default(this, null, 1, null));
    }

    private final File getFileAndCheck(String extension) {
        File file;
        File it = file = this.getFile(extension);
        boolean bl = false;
        byte[] byArray = Files.readAllBytes(this.getFile(extension + ".sha1").toPath());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(getFile(\"$extension.sha1\").toPath())");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        if (!Intrinsics.areEqual((Object)new String(byArray2, charset), (Object)this.toSha1(it))) {
            it.delete();
            throw new IllegalStateException("file " + it.getName() + " sha1 not match.");
        }
        return file;
    }

    static /* synthetic */ File getFileAndCheck$default(MavenDependency mavenDependency, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "jar";
        }
        return mavenDependency.getFileAndCheck(string);
    }

    private final File getFile(String extension) {
        Object object;
        block5: {
            object = new String[4];
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            object[0] = StringsKt.replace$default((String)this.groupId, (String)".", (String)string, (boolean)false, (int)4, null);
            object[1] = this.artifactId;
            object[2] = this.version;
            object[3] = this.artifactId + '-' + this.version + '.' + extension;
            Object it = object = Paths.get(this.libPath, (String[])object).toFile();
            boolean bl = false;
            if (!((File)it).exists()) {
                ((File)it).getParentFile().mkdirs();
                for (String repoUrl : this.repos) {
                    URL url = new URL(repoUrl + '/' + StringsKt.replace$default((String)this.groupId, (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + '-' + this.version + '.' + extension);
                    try {
                        URLConnection connection = url.openConnection();
                        connection.setConnectTimeout(5000);
                        connection.setReadTimeout(120000);
                        connection.setUseCaches(true);
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        Files.copy(connection.getInputStream(), ((File)it).toPath(), copyOptionArray);
                        if (Intrinsics.areEqual((Object)extension, (Object)"jar")) {
                            System.out.println((Object)("Successfully downloaded " + this.groupId + ':' + this.artifactId + ':' + this.version + ":jar"));
                        }
                        break block5;
                    }
                    catch (IOException e) {
                        System.out.println((Object)("Failed to download " + this.groupId + ':' + this.artifactId + ':' + this.version + ':' + extension + " from " + repoUrl));
                    }
                }
                throw new RuntimeException("Failed to download file: " + this.groupId + ':' + this.artifactId + ':' + this.version + ':' + extension);
            }
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(\n            libPath\u2026)\n            }\n        }");
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String toSha1(File $this$toSha1) {
        Closeable closeable = new FileInputStream($this$toSha1);
        Throwable throwable = null;
        try {
            FileInputStream fis = (FileInputStream)closeable;
            boolean bl = false;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[8192];
            int len = 0;
            while (true) {
                int n;
                int it = n = fis.read(buffer);
                boolean bl2 = false;
                len = it;
                if (n == -1) break;
                digest.update(buffer, 0, len);
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
            String string = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)toSha1.1.2.INSTANCE, (int)30, null);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

