/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.nms;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.neige.neigeitems.nms.ItemTagData;
import pers.neige.neigeitems.utils.NMSUtils;

public class ItemTag
extends ItemTagData
implements Map<String, ItemTagData> {
    private final Object nbt;
    private final Map<String, Object> map;

    public Object getNbt() {
        return this.nbt;
    }

    public ItemTag() {
        super(NMSUtils.newItemTag());
        this.nbt = this.data;
        this.map = NMSUtils.getNbtMap(this.nbt);
    }

    public ItemTag(Object nbt) {
        super(nbt);
        this.nbt = this.data;
        this.map = NMSUtils.getNbtMap(nbt);
    }

    public void saveTo(ItemStack itemStack) {
        NMSUtils.setItemTag(itemStack, this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 instanceof ItemTagData) {
            return this.map.containsValue(((ItemTagData)value2).data);
        }
        return this.map.containsValue(value2);
    }

    @Override
    @Nullable
    public ItemTagData get(Object key2) {
        Object value2 = this.map.get(key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return null;
    }

    @NotNull
    public ItemTagData getOrElse(String key2, @NotNull ItemTagData base) {
        Object value2 = this.map.get(key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return base;
    }

    @NotNull
    public ItemTagData getOrPut(String key2, @NotNull ItemTagData base) {
        Object value2 = this.map.get(key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return this.put(key2, base);
    }

    @Nullable
    public ItemTagData getDeep(String key2) {
        Object value2 = NMSUtils.getDeep(this.nbt, key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return null;
    }

    @NotNull
    public ItemTagData getDeepOrElse(String key2, @NotNull ItemTagData base) {
        Object value2 = NMSUtils.getDeep(this.nbt, key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return base;
    }

    @NotNull
    public ItemTagData getDeepOrPut(String key2, @NotNull ItemTagData base) {
        Object value2 = NMSUtils.getDeep(this.nbt, key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return this.putDeep(key2, base);
    }

    @Override
    @Nullable
    public ItemTagData put(String key2, @Nullable ItemTagData value2) {
        if (value2 == null) {
            this.map.remove(key2);
            return null;
        }
        this.map.put(key2, value2.data);
        return value2;
    }

    @Override
    @Nullable
    public ItemTagData put(String key2, @Nullable Object value2) {
        if (value2 == null) {
            this.map.remove(key2);
            return null;
        }
        Object result2 = NMSUtils.asNBT(value2);
        this.map.put(key2, result2);
        return new ItemTagData(result2);
    }

    @Nullable
    public ItemTagData putDeep(String key2, @Nullable ItemTagData value2) {
        NMSUtils.putDeep(this.nbt, key2, value2.data);
        return value2;
    }

    @Nullable
    public ItemTagData putDeep(String key2, @Nullable Object value2) {
        if (value2 == null) {
            this.putDeep(key2, null);
            return null;
        }
        Object result2 = NMSUtils.asNBT(value2);
        NMSUtils.putDeep(this.nbt, key2, result2);
        return new ItemTagData(result2);
    }

    @Override
    public ItemTagData remove(Object key2) {
        Object value2 = this.map.remove(key2);
        if (value2 != null) {
            return new ItemTagData(value2);
        }
        return null;
    }

    public ItemTagData removeDeep(String key2) {
        ItemTagData result2 = this.getDeep(key2);
        this.putDeep(key2, null);
        return result2;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends ItemTagData> m) {
        m.forEach((key2, value2) -> this.map.put((String)key2, value2.data));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<ItemTagData> values() {
        HashSet<ItemTagData> temp = new HashSet<ItemTagData>();
        this.map.values().forEach((? super T value2) -> temp.add(new ItemTagData(value2)));
        return temp;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, ItemTagData>> entrySet() {
        HashMap tempMap = new HashMap();
        this.map.forEach((key2, value2) -> tempMap.put(key2, new ItemTagData(value2)));
        return tempMap.entrySet();
    }
}

