/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.nms;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import pers.neige.neigeitems.nms.ItemTag;
import pers.neige.neigeitems.nms.ItemTagList;
import pers.neige.neigeitems.nms.ItemTagType;
import pers.neige.neigeitems.utils.NMSUtils;

public class ItemTagData {
    protected ItemTagType type;
    protected Object data;

    public ItemTagType getType() {
        return this.type;
    }

    public ItemTagData(String data) {
        this.type = ItemTagType.STRING;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(Byte data) {
        this.type = ItemTagType.BYTE;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(byte[] data) {
        this.type = ItemTagType.BYTE_ARRAY;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(int data) {
        this.type = ItemTagType.INT;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(int[] data) {
        this.type = ItemTagType.INT_ARRAY;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(double data) {
        this.type = ItemTagType.DOUBLE;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(float data) {
        this.type = ItemTagType.FLOAT;
        this.data = NMSUtils.asNBT(Float.valueOf(data));
    }

    public ItemTagData(short data) {
        this.type = ItemTagType.SHORT;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(long data) {
        this.type = ItemTagType.LONG;
        this.data = NMSUtils.asNBT(data);
    }

    public ItemTagData(ItemTag data) {
        this.type = ItemTagType.COMPOUND;
        this.data = data.getNbt();
    }

    public ItemTagData(ItemTagList data) {
        this.type = ItemTagType.LIST;
        this.data = data.getNbt();
    }

    public ItemTagData(Object data) {
        this.type = NMSUtils.getNBTType(data);
        this.data = data;
    }

    public ItemTagData(List<?> data) {
        this.type = ItemTagType.LIST;
        this.data = NMSUtils.asNBT(data);
    }

    public String asString() {
        return NMSUtils.asString(this.data);
    }

    public byte asByte() {
        return NMSUtils.asByte(this.data);
    }

    public byte[] asByteArray() {
        return NMSUtils.asByteArray(this.data);
    }

    public int asInt() {
        return NMSUtils.asInt(this.data);
    }

    public int[] asIntArray() {
        return NMSUtils.asIntArray(this.data);
    }

    public double asDouble() {
        return NMSUtils.asDouble(this.data);
    }

    public float asFloat() {
        return NMSUtils.asFloat(this.data);
    }

    public short asShort() {
        return NMSUtils.asShort(this.data);
    }

    public long asLong() {
        return NMSUtils.asLong(this.data);
    }

    public ItemTag asCompound() {
        return new ItemTag(this.data);
    }

    @Nullable
    public ItemTagList asList() {
        if (this.type == ItemTagType.LIST) {
            return new ItemTagList((AbstractList)this.data);
        }
        ItemTagList temp = new ItemTagList();
        temp.getNbt().add(this.data);
        return temp;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.data});
    }

    public String toString() {
        return NMSUtils.toString(this.data);
    }
}

