/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.taboolib.module.nms;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin1720.Unit;
import kotlin1720.jvm.functions.Function1;
import kotlin1720.jvm.internal.Intrinsics;
import kotlin1720.text.Charsets;
import kotlin1720.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0001H&J \u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H&J4\u0010\u0014\u001a\u00020\u0000\"\u000e\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005H&J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H&J\u0016\u0010*\u001a\u00020\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010,H&J1\u0010-\u001a\u00020\u0000\"\u0004\b\u0000\u0010.2\b\u0010/\u001a\u0004\u0018\u0001H.2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020201H\u0016\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206H&J\u0010\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<H\u0016J\u001a\u0010=\u001a\u00020\u00002\u0006\u00108\u001a\u0002092\b\b\u0002\u0010>\u001a\u00020\u0005H\u0016J\u0010\u0010?\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020BH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006C\u00c0\u0006\u0001"}, d2={"Lpers/neige/neigeitems/taboolib/module/nms/DataSerializer;", "", "build", "writeBlockPosition", "x", "", "y", "z", "writeBoolean", "boolean", "", "writeByte", "byte", "", "writeBytes", "bytes", "", "writeDouble", "double", "", "writeEnumSet", "E", "", "enumSet", "Ljava/util/EnumSet;", "enumClass", "Ljava/lang/Class;", "writeFixedBitSet", "bitSet", "Ljava/util/BitSet;", "size", "writeFloat", "float", "", "writeGameProfileProperties", "map", "Lcom/mojang/authlib/properties/PropertyMap;", "writeInt", "int", "writeLong", "long", "", "writeMetadata", "meta", "", "writeNullable", "T", "value", "writer", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lpers/neige/neigeitems/taboolib/module/nms/DataSerializer;", "writeShort", "short", "", "writeString", "string", "", "writeUUID", "uuid", "Ljava/util/UUID;", "writeUtf", "length", "writeVarInt", "writeVarIntArray", "intArray", "", "module-nms"})
public interface DataSerializer {
    @NotNull
    public DataSerializer writeByte(byte var1);

    @NotNull
    public DataSerializer writeBytes(@NotNull byte[] var1);

    @NotNull
    public DataSerializer writeShort(short var1);

    @NotNull
    public DataSerializer writeInt(int var1);

    @NotNull
    public DataSerializer writeLong(long var1);

    @NotNull
    public DataSerializer writeFloat(float var1);

    @NotNull
    public DataSerializer writeDouble(double var1);

    @NotNull
    public DataSerializer writeBoolean(boolean var1);

    @NotNull
    public DataSerializer writeMetadata(@NotNull List<? extends Object> var1);

    @NotNull
    default public DataSerializer writeUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    @NotNull
    default public DataSerializer writeBlockPosition(int x, int y, int z) {
        this.writeLong(((long)x & 0x3FFFFFFL) << 38 | ((long)y & 0xFFFL) << 26 | ((long)z & 0x3FFFFFFL) << 0);
        return this;
    }

    @NotNull
    default public DataSerializer writeVarIntArray(@NotNull int[] intArray) {
        Intrinsics.checkNotNullParameter((Object)intArray, (String)"intArray");
        this.writeVarInt(intArray.length);
        int[] $this$forEach$iv = intArray;
        boolean $i$f$forEach = false;
        int[] nArray = $this$forEach$iv;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = nArray[i];
            boolean bl = false;
            this.writeVarInt(it);
        }
        return this;
    }

    @NotNull
    default public DataSerializer writeVarInt(int n) {
        int i = n;
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
        return this;
    }

    @NotNull
    default public <T> DataSerializer writeNullable(@Nullable T value2, @NotNull Function1<? super T, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (value2 == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            writer.invoke(value2);
        }
        return this;
    }

    @NotNull
    default public <E extends Enum<E>> DataSerializer writeEnumSet(@NotNull EnumSet<E> enumSet, @NotNull Class<E> enumClass) {
        Intrinsics.checkNotNullParameter(enumSet, (String)"enumSet");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        BitSet bitSet = new BitSet(enumConstants.length);
        int n = 0;
        int n2 = enumConstants.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                bitSet.set(i, enumSet.contains(enumConstants[i]));
            } while (n <= n2);
        }
        this.writeFixedBitSet(bitSet, enumConstants.length);
        return this;
    }

    @NotNull
    default public DataSerializer writeFixedBitSet(@NotNull BitSet bitSet, int size) {
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        if (bitSet.length() > size) {
            throw new EncoderException("BitSet is larger than expected size (" + bitSet.length() + '>' + size + ')');
        }
        byte[] byArray = bitSet.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bitSet.toByteArray()");
        int n = -Math.floorDiv(-size, 8);
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        this.writeBytes(byArray2);
        return this;
    }

    @NotNull
    default public DataSerializer writeString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] arr = byArray;
        if (arr.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + string.length() + " bytes encoded, max 32767)");
        }
        this.writeVarInt(arr.length);
        this.writeBytes(arr);
        return this;
    }

    @NotNull
    default public DataSerializer writeUtf(@NotNull String string, int length) {
        int maxEncodedUtfLength;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (string.length() > length) {
            throw new EncoderException("String too big (was " + string.length() + " bytes encoded, max 32767)");
        }
        byte[] arr = StringsKt.encodeToByteArray((String)string);
        if (arr.length > (maxEncodedUtfLength = length * 3)) {
            throw new EncoderException("String too big (was " + arr.length + " bytes encoded, max " + maxEncodedUtfLength + ')');
        }
        this.writeVarInt(arr.length);
        this.writeBytes(arr);
        return this;
    }

    public static /* synthetic */ DataSerializer writeUtf$default(DataSerializer dataSerializer, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeUtf");
        }
        if ((n2 & 2) != 0) {
            n = Short.MAX_VALUE;
        }
        return dataSerializer.writeUtf(string, n);
    }

    @NotNull
    default public DataSerializer writeGameProfileProperties(@NotNull PropertyMap map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.writeVarInt(map.size());
        Collection collection = map.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"map.values()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Property property = (Property)element$iv;
            boolean bl = false;
            String string = property.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.name");
            DataSerializer.writeUtf$default(this, string, 0, 2, null);
            string = property.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.value");
            DataSerializer.writeUtf$default(this, string, 0, 2, null);
            if (property.hasSignature()) {
                this.writeBoolean(true);
                string = property.getSignature();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.signature");
                DataSerializer.writeUtf$default(this, string, 0, 2, null);
                continue;
            }
            this.writeBoolean(false);
        }
        return this;
    }

    @NotNull
    public Object build();
}

