/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.taboolib.platform;

import java.lang.reflect.Field;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import pers.neige.neigeitems.taboolib.common.LifeCycle;
import pers.neige.neigeitems.taboolib.common.TabooLibCommon;
import pers.neige.neigeitems.taboolib.common.io.Project1Kt;
import pers.neige.neigeitems.taboolib.common.platform.Platform;
import pers.neige.neigeitems.taboolib.common.platform.function.ExecutorKt;
import pers.neige.neigeitems.taboolib.library.reflex.Reflex;
import pers.neige.neigeitems.taboolib.platform.BukkitPlugin;

public class BukkitPluginDelegate {
    private final Field pluginInstance = Class.forName("pers.neige.neigeitems.taboolib.platform.BukkitPlugin").getDeclaredField("pluginInstance");

    public BukkitPluginDelegate() throws ClassNotFoundException, NoSuchFieldException {
        this.pluginInstance.setAccessible(true);
    }

    public void onConst() throws IllegalAccessException {
        TabooLibCommon.lifeCycle(LifeCycle.CONST, Platform.BUKKIT);
        if (TabooLibCommon.isKotlinEnvironment()) {
            this.pluginInstance.set(null, Project1Kt.findImplementation(pers.neige.neigeitems.taboolib.common.platform.Plugin.class));
        }
    }

    public void onInit() {
        BukkitPluginDelegate.injectAccess();
        TabooLibCommon.lifeCycle(LifeCycle.INIT);
    }

    public void onLoad() throws IllegalAccessException {
        TabooLibCommon.lifeCycle(LifeCycle.LOAD);
        if (BukkitPlugin.getPluginInstance() == null) {
            this.pluginInstance.set(null, Project1Kt.findImplementation(pers.neige.neigeitems.taboolib.common.platform.Plugin.class));
        }
        if (BukkitPlugin.getPluginInstance() != null && !TabooLibCommon.isStopped()) {
            BukkitPlugin.getPluginInstance().onLoad();
        }
    }

    public void onEnable() {
        TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
        if (!TabooLibCommon.isStopped()) {
            if (BukkitPlugin.getPluginInstance() != null) {
                BukkitPlugin.getPluginInstance().onEnable();
            }
            try {
                ExecutorKt.startExecutor();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!TabooLibCommon.isStopped()) {
            Bukkit.getScheduler().runTask((Plugin)BukkitPlugin.getInstance(), new Runnable(){

                @Override
                public void run() {
                    TabooLibCommon.lifeCycle(LifeCycle.ACTIVE);
                    if (BukkitPlugin.getPluginInstance() != null) {
                        BukkitPlugin.getPluginInstance().onActive();
                    }
                }
            });
        }
    }

    public void onDisable() {
        TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
        if (BukkitPlugin.getPluginInstance() != null && !TabooLibCommon.isStopped()) {
            BukkitPlugin.getPluginInstance().onDisable();
        }
    }

    static void injectAccess() {
        try {
            PluginDescriptionFile description = (PluginDescriptionFile)Reflex.Companion.getProperty(BukkitPlugin.class.getClassLoader(), "description", false, true, false);
            Set accessSelf = (Set)Reflex.Companion.getProperty(BukkitPlugin.class.getClassLoader(), "seenIllegalAccess", false, true, false);
            for (Plugin plugin2 : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin2.getClass().getName().endsWith("platform.BukkitPlugin")) continue;
                Set accessOther = (Set)Reflex.Companion.getProperty(plugin2.getClass().getClassLoader(), "seenIllegalAccess", false, true, false);
                accessOther.add(description.getName());
                accessSelf.add(plugin2.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

