/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin1720.Pair;
import kotlin1720.TuplesKt;
import kotlin1720.collections.CollectionsKt;
import kotlin1720.comparisons.ComparisonsKt;
import kotlin1720.jvm.JvmStatic;
import kotlin1720.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J)\u0010\u000b\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\rJ1\u0010\u000b\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00110\u0007H\u0007\u00a2\u0006\u0002\u0010\rJ1\u0010\u0010\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00110\u00072\u0006\u0010\u000e\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lpers/neige/neigeitems/utils/SamplingUtils;", "", "()V", "aExpj", "", "T", "samples", "", "", "amount", "", "weight", "info", "(Ljava/util/Map;)Ljava/lang/Object;", "total", "(Ljava/util/Map;D)Ljava/lang/Object;", "weightBigDecimal", "Ljava/math/BigDecimal;", "(Ljava/util/Map;Ljava/math/BigDecimal;)Ljava/lang/Object;", "NeigeItems"})
public final class SamplingUtils {
    @NotNull
    public static final SamplingUtils INSTANCE = new SamplingUtils();

    private SamplingUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final <T> List<T> aExpj(@NotNull Map<T, Double> samples, int amount) {
        void $this$mapTo$iv$iv;
        Object item;
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        if (amount <= 0) {
            return new ArrayList();
        }
        if (amount == samples.size()) {
            return CollectionsKt.toList((Iterable)samples.keySet());
        }
        PriorityQueue<Pair> heap = new PriorityQueue<Pair>(new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getFirst()));
            }
        });
        Double thresholdX = null;
        double thresholdT = 0.0;
        double weightAcc = 0.0;
        for (Map.Entry<T, Double> entry : samples.entrySet()) {
            double randNum;
            item = entry.getKey();
            double weight = ((Number)entry.getValue()).doubleValue();
            if (heap.size() < amount) {
                randNum = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
                double ki = Math.pow(randNum, 1.0 / weight);
                heap.add(TuplesKt.to((Object)ki, item));
                continue;
            }
            if (weightAcc == 0.0) {
                thresholdT = ((Number)((Pair)heap.peek()).getFirst()).doubleValue();
                randNum = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
                thresholdX = Math.log(randNum) / Math.log(thresholdT);
            }
            Double d = thresholdX;
            Intrinsics.checkNotNull(d);
            if (weightAcc + weight < d) {
                weightAcc += weight;
                continue;
            }
            weightAcc = 0.0;
            double tW = Math.pow(thresholdT, weight);
            double randNum2 = ThreadLocalRandom.current().nextDouble(tW, 1.0);
            double ki = Math.pow(randNum2, 1.0 / weight);
            heap.poll();
            heap.add(TuplesKt.to((Object)ki, item));
        }
        Iterable $this$map$iv = heap;
        boolean $i$f$map = false;
        item = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair randNum2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSecond());
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @Nullable
    public static final <T> T weight(@NotNull Map<T, Double> info) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        double total = 0.0;
        Iterator<Double> iterator = info.values().iterator();
        while (iterator.hasNext()) {
            double value2 = ((Number)iterator.next()).doubleValue();
            total += value2;
        }
        return SamplingUtils.weight(info, total);
    }

    @JvmStatic
    @Nullable
    public static final <T> T weight(@NotNull Map<T, Double> info, double total) {
        Object v0;
        Intrinsics.checkNotNullParameter(info, (String)"info");
        if (info.isEmpty()) {
            v0 = null;
        } else {
            double random = ThreadLocalRandom.current().nextDouble() * total;
            double current = 0.0;
            Object result2 = null;
            for (Map.Entry<T, Double> entry : info.entrySet()) {
                T key2 = entry.getKey();
                double value2 = ((Number)entry.getValue()).doubleValue();
                if (!(random <= (current += value2))) continue;
                result2 = key2;
                break;
            }
            v0 = result2;
        }
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final <T> T weightBigDecimal(@NotNull Map<T, ? extends BigDecimal> info) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        BigDecimal total = BigDecimal.ZERO;
        for (BigDecimal bigDecimal : info.values()) {
            total = total.add(bigDecimal);
        }
        BigDecimal bigDecimal = total;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"total");
        return SamplingUtils.weightBigDecimal(info, bigDecimal);
    }

    @JvmStatic
    @Nullable
    public static final <T> T weightBigDecimal(@NotNull Map<T, ? extends BigDecimal> info, @NotNull BigDecimal total) {
        Object v0;
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)total, (String)"total");
        if (info.isEmpty()) {
            v0 = null;
        } else {
            BigDecimal random = new BigDecimal(String.valueOf(ThreadLocalRandom.current().nextDouble())).multiply(total);
            BigDecimal current = BigDecimal.ZERO;
            Object result2 = null;
            for (Map.Entry<T, BigDecimal> entry : info.entrySet()) {
                T key2 = entry.getKey();
                BigDecimal value2 = entry.getValue();
                if (random.compareTo(current = current.add(value2)) > 0) continue;
                result2 = key2;
                break;
            }
            v0 = result2;
        }
        return v0;
    }
}

