/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee;

import com.google.common.collect.Multimap;
import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import eu.nononitas.plhidepro.PlHidePlayerManagerImpl;
import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.PlHideProvider;
import eu.nononitas.plhidepro.bungee.PlHideBungeeCmd;
import eu.nononitas.plhidepro.bungee.impl.BungeeConfig;
import eu.nononitas.plhidepro.bungee.impl.Logger;
import eu.nononitas.plhidepro.bungee.listeners.CommandListener;
import eu.nononitas.plhidepro.bungee.listeners.CommandSuggestionListener;
import eu.nononitas.plhidepro.bungee.listeners.JoinLeaveListener;
import eu.nononitas.plhidepro.bungee.listeners.PluginMessagesListener;
import eu.nononitas.plhidepro.bungee.listeners.TabCompleteListener;
import eu.nononitas.plhidepro.bungee.miscellaneous.BungeePluginMessageHandler;
import eu.nononitas.plhidepro.bungee.miscellaneous.ConfigHandler;
import eu.nononitas.plhidepro.libs.org.bstats.bungeecord.Metrics;
import eu.nononitas.plhidepro.miscellaneous.CommandsListManager;
import eu.nononitas.plhidepro.miscellaneous.Database;
import eu.nononitas.plhidepro.miscellaneous.DebugLogger;
import eu.nononitas.plhidepro.miscellaneous.IConfig;
import eu.nononitas.plhidepro.miscellaneous.ILogger;
import eu.nononitas.plhidepro.miscellaneous.LuckPermsListener;
import eu.nononitas.plhidepro.util.PluginCommandsInfo;
import eu.nononitas.plhidepro.util.Updater;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.config.Configuration;
import org.jetbrains.annotations.Nullable;

public class PlHideProBungee
implements PlHidePro {
    public static final String PREFIX = "\u00a73Pl\u00a77-\u00a73Hide\u00a77-\u00a76Pro\u00a77-\u00a79Bungee \u00a78\u258e \u00a7r";
    public static final int CONFIG_VERSION = 11;
    private static PlHideProBungee instance;
    private final Plugin plugin;
    private ConfigHandler configHandler;
    private final BungeePluginMessageHandler pluginMessageHandler;
    private IConfig config;
    private DebugLogger debugLogger;
    private final CommandsListManager commandsListManager = new CommandsListManager(this);
    private Logger logger;
    private Database database;

    public PlHideProBungee(Plugin plugin) {
        this.plugin = plugin;
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        this.pluginMessageHandler = new BungeePluginMessageHandler(this);
    }

    public static PlHideProBungee getInstance() {
        return instance;
    }

    void enable() {
        PlHideProvider.setPlHidePro(this);
        this.configHandler = new ConfigHandler(new File(this.plugin.getDataFolder(), "config.yml"));
        this.loadConfig();
        this.enableLogger();
        if (!this.updateConfig()) {
            this.logger.error("Config update failed. Disabling Plugin");
            return;
        }
        this.commandsListManager.loadLists();
        this.checkConfig();
        this.database = new Database(this.getDataFolder().toPath(), this);
        this.registerListener();
        Updater.currentVersion = this.plugin.getDescription().getVersion();
        ProxyServer.getInstance().getScheduler().runAsync(this.plugin, () -> {
            Updater.updatecheck(false).ifPresent(string -> this.getLogger().info((String)string));
            new Metrics(this.plugin, 7044);
        });
        this.plugin.getProxy().registerChannel("plhidepro:tab");
        this.plugin.getProxy().getPluginManager().registerListener(this.plugin, (Listener)this.pluginMessageHandler);
        this.plugin.getProxy().getScheduler().schedule(this.plugin, PlHideProBungee::setPluginCommandsInfo, 500L, TimeUnit.MILLISECONDS);
        if (this.plugin.getProxy().getPluginManager().getPlugin("LuckPerms") != null) {
            LuckPermsListener.init(this.plugin);
        }
    }

    void disable() {
        this.debugLogger.close();
        this.database.closeConnection();
    }

    private void enableLogger() {
        this.debugLogger = new DebugLogger(this.plugin.getDataFolder().getPath(), this.getConfig().getBoolean("debug"));
        this.logger = new Logger(this.plugin.getLogger(), this.debugLogger);
    }

    private static void setPluginCommandsInfo() {
        Multimap multimap;
        Field field;
        try {
            field = Class.forName("net.md_5.bungee.api.plugin.PluginManager").getDeclaredField("commandsByPlugin");
            field.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return;
        }
        try {
            multimap = (Multimap)field.get(ProxyServer.getInstance().getPluginManager());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
        Map map = multimap.asMap();
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = iterator.next();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)entry.getKey();
            if (plugin != null && plugin.getDescription() != null && plugin.getDescription().getName() != null) {
                PluginCommandsInfo.addCommands(plugin.getDescription().getName(), ((Collection)entry.getValue()).stream().map(Command::getName).collect(Collectors.toList()));
            }
            entry = iterator.next();
        }
    }

    private void registerListener() {
        PluginManager pluginManager = this.plugin.getProxy().getPluginManager();
        pluginManager.registerListener(this.plugin, (Listener)new TabCompleteListener(this));
        pluginManager.registerListener(this.plugin, (Listener)new CommandListener(this));
        pluginManager.registerListener(this.plugin, (Listener)new CommandSuggestionListener(this));
        pluginManager.registerListener(this.plugin, (Listener)new JoinLeaveListener(this));
        pluginManager.registerCommand(this.plugin, (Command)new PlHideBungeeCmd(this));
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new CommandSuggestionListener(this));
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new PluginMessagesListener(this));
    }

    public boolean checkConfig() {
        Configuration configuration = this.getConfigHandler().getConfiguration().getSection("groups");
        ILogger iLogger = this.getLogger();
        boolean bl = true;
        if (!configuration.contains("default")) {
            iLogger.error("default group is missing");
            bl = false;
        }
        for (String string : configuration.getKeys()) {
            if (!configuration.contains(string + ".servers.fallback.commands") && !configuration.contains(string + ".servers.all.commands")) {
                iLogger.error("A fallback or \"all\" list is missing at the commands section in group " + string + ". Please add one of the lists mentioned");
                bl = false;
            }
            if (!configuration.contains(string + ".servers.fallback.tabcomplete") && !configuration.contains(string + ".servers.all.tabcomplete")) {
                iLogger.error("A fallback or \"all\" list is missing at the tabcomplete section in group " + string + ". Please add one of the lists mentioned");
                bl = false;
            }
            if (!configuration.contains(string + ".priority")) {
                iLogger.error("The option priority is missing for the group " + string);
                bl = false;
            }
            if (!configuration.contains(string + ".blocked-command-message")) {
                iLogger.error("The option blocked-command-message is missing for the group " + string);
                bl = false;
            }
            if (!configuration.contains(string + ".enabled_servers")) {
                iLogger.error("The list enabled_servers is missing for the group " + string);
                bl = false;
            }
            if (configuration.contains(string + ".inherited-groups")) continue;
            iLogger.error("The option inherited-groups is missing for the group " + string);
            bl = false;
        }
        return bl;
    }

    void loadConfig() {
        if (!this.configHandler.exists()) {
            this.configHandler.createDefaultFile();
        }
        this.configHandler.load();
        this.config = new BungeeConfig(this.configHandler.getConfiguration());
    }

    boolean updateConfig() {
        int n = 11;
        int n2 = this.getConfig().getInt("version");
        ILogger iLogger = this.getLogger();
        File file = this.plugin.getDataFolder();
        File file2 = new File(file, "backups");
        ConfigHandler configHandler = new ConfigHandler(new File(file, "config_with_explanations.yml"));
        configHandler.createDefaultFile();
        if (n2 < n) {
            file2.mkdir();
            try {
                iLogger.warn("\u00a73Pl\u00a77-\u00a73Hide\u00a77-\u00a76Pro\u00a77-\u00a79Bungee \u00a78\u258e \u00a7r\u00a7eNew config version available. Creating backup with the name \u00a7cconfig-old-" + n2 + ".yml in the backups folder");
                Files.copy(Paths.get(file + "/config.yml", new String[0]), Paths.get(file2 + "/config-old-" + n2 + ".yml", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            try {
                ConfigHandler configHandler2 = this.getConfigHandler();
                Configuration configuration = this.getConfigHandler().getConfiguration();
                while (n2 < n) {
                    switch (n2) {
                        case 7: {
                            configuration.set("block-plugin-named-commands-tabcomplete", null);
                            configuration.set("block-plugin-named-commands-execution", null);
                            Configuration configuration2 = configuration.getSection("groups");
                            for (Object object : configuration2.getKeys()) {
                                configuration2.set((String)object + ".group-mode-commands", null);
                                configuration2.set((String)object + ".group-mode-tabcomplete", null);
                            }
                            break;
                        }
                        case 8: {
                            Configuration configuration2 = configuration.getSection("groups");
                            for (Object object : configuration2.getKeys()) {
                                configuration2.set((String)object + ".inherited-groups", (Object)configuration2.getList((String)object + ".included-groups"));
                                configuration2.set((String)object + ".included-groups", null);
                            }
                            break;
                        }
                        case 9: {
                            Configuration configuration2 = configuration.getSection("groups");
                            for (Object object : configuration2.getKeys()) {
                                configuration2.set((String)object + ".enabled_servers", (Object)configuration2.getList((String)object + ".servers"));
                                configuration2.set((String)object + ".servers", null);
                                configuration2.set((String)object + ".servers.all.commands", (Object)configuration2.getList((String)object + ".commands"));
                                configuration2.set((String)object + ".servers.all.tabcomplete", (Object)configuration2.getList((String)object + ".tabcomplete"));
                                configuration2.set((String)object + ".commands", null);
                                configuration2.set((String)object + ".tabcomplete", null);
                            }
                            break;
                        }
                        case 10: {
                            Object object;
                            configuration.set("auto_lowercase_base_commands", (Object)true);
                            Iterator iterator = Paths.get(this.getDataFolder().toPath().resolve("lists.yml").toUri());
                            object = this.getDataFolder().toPath().resolve("lists");
                            object.toFile().mkdirs();
                            Path path = Paths.get(object.resolve("lists.yml").toUri());
                            try {
                                Files.move(iterator, path, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                break;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                this.getLogger().error("Automatically migrating the lists.yml failed. Please move the lists.yml manually into the lists folder!");
                            }
                        }
                    }
                    configuration.set("version", (Object)(++n2));
                    configHandler2.save();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setDebugStatus(boolean bl) {
        this.debugLogger.setActive(bl);
    }

    @Nullable
    public String getColoredConfigString(String string) {
        String string2 = this.getConfigHandler().getConfiguration().getString(string);
        if (string2 != null) {
            string2 = PlHidePro.translateColor(string2);
        }
        return string2;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    @Override
    public PlHidePlayerManagerImpl getPlayerManager() {
        return PlHidePro.super.getPlayerManager();
    }

    @Override
    public IConfig getConfig(File file) {
        ConfigHandler configHandler = new ConfigHandler(file);
        configHandler.load();
        return new BungeeConfig(configHandler.getConfiguration());
    }

    public String getBrandChannel(ProxiedPlayer proxiedPlayer) {
        return proxiedPlayer.getPendingConnection().getVersion() < 393 ? "MC|Brand" : "minecraft:brand";
    }

    public BungeePluginMessageHandler getPluginMessageHandler() {
        return this.pluginMessageHandler;
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public CommandsListManager getListManager() {
        return this.commandsListManager;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }
}

