/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.impl;

import eu.nononitas.plhidepro.miscellaneous.IConfig;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.config.Configuration;
import org.jetbrains.annotations.NotNull;

public class BungeeConfig
implements IConfig {
    private final Configuration config;
    private Map<String, Object> map;

    public BungeeConfig(@NotNull Configuration configuration) {
        this.config = configuration;
        try {
            Field field = Configuration.class.getDeclaredField("self");
            field.setAccessible(true);
            this.map = (Map)field.get(configuration);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            this.map = new HashMap<String, Object>();
        }
    }

    @Override
    public List<String> getStringList(String string) {
        return Collections.unmodifiableList(this.config.getStringList(string));
    }

    @Override
    public int getInt(String string) {
        return this.config.getInt(string);
    }

    @Override
    public String getString(String string) {
        return this.config.getString(string);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.config.getBoolean(string);
    }

    @Override
    public IConfig getSection(String string) {
        return new BungeeConfig((Configuration)this.map.getOrDefault(string, new Configuration()));
    }

    @Override
    public IConfig getSection(String ... stringArray) {
        IConfig iConfig = this;
        for (String string : stringArray) {
            iConfig = iConfig.getSection(string);
        }
        return iConfig;
    }

    @Override
    public boolean containsKey(String string) {
        return this.map.containsKey(string);
    }

    @Override
    public Collection<String> getAllKeys() {
        return this.config.getKeys();
    }
}

