/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.libs.net.byteflux.libby.relocation;

import eu.nononitas.plhidepro.libs.net.byteflux.libby.Library;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.LibraryManager;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.classloader.IsolatedClassLoader;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.relocation.Relocation;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;

public class RelocationHelper {
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;
    private final Constructor<?> relocationConstructor;

    public RelocationHelper(LibraryManager libraryManager) {
        Objects.requireNonNull(libraryManager, "libraryManager");
        IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader(new URL[0]);
        isolatedClassLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("org.ow2.asm").artifactId("asm-commons").version("9.2").checksum("vkzlMTiiOLtSLNeBz5Hzulzi9sqT7GLUahYqEnIl4KY=").repository("https://repo1.maven.org/maven2/").build()));
        isolatedClassLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("org.ow2.asm").artifactId("asm").version("9.2").checksum("udT+TXGTjfOIOfDspCqqpkz4sxPWeNoDbwyzyhmbR/U=").repository("https://repo1.maven.org/maven2/").build()));
        isolatedClassLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("me.lucko").artifactId("jar-relocator").version("1.5").checksum("0D6eM99gKpEYFNDydgnto3Df0ygZGdRVqy5ahtj0oIs=").repository("https://repo1.maven.org/maven2/").build()));
        try {
            Class<?> clazz = isolatedClassLoader.loadClass("me.lucko.jarrelocator.JarRelocator");
            Class<?> clazz2 = isolatedClassLoader.loadClass("me.lucko.jarrelocator.Relocation");
            this.jarRelocatorConstructor = clazz.getConstructor(File.class, File.class, Collection.class);
            this.jarRelocatorRunMethod = clazz.getMethod("run", new Class[0]);
            this.relocationConstructor = clazz2.getConstructor(String.class, String.class, Collection.class, Collection.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void relocate(Path path, Path path2, Collection<Relocation> collection) {
        Objects.requireNonNull(path, "in");
        Objects.requireNonNull(path2, "out");
        Objects.requireNonNull(collection, "relocations");
        try {
            LinkedList linkedList = new LinkedList();
            for (Relocation relocation : collection) {
                linkedList.add(this.relocationConstructor.newInstance(relocation.getPattern(), relocation.getRelocatedPattern(), relocation.getIncludes(), relocation.getExcludes()));
            }
            this.jarRelocatorRunMethod.invoke(this.jarRelocatorConstructor.newInstance(path.toFile(), path2.toFile(), linkedList), new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

