/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.miscellaneous;

import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.util.PluginCommandsInfo;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Database {
    private Connection connection;
    private final Path dataFolderPath;
    private final PlHidePro plHide;

    public Database(Path path, PlHidePro plHidePro) {
        this.dataFolderPath = path;
        this.plHide = plHidePro;
        this.openConnection();
        this.update("CREATE TABLE IF NOT EXISTS plugin_commands_info (PLUGIN varchar(250), COMMAND varchar(250), DATE DATE, HASH integer, UNIQUE (HASH))");
        this.cleanUp();
        this.loadPluginData();
    }

    public void openConnection() {
        try {
            if (this.getConnection() != null && !this.getConnection().isClosed()) {
                this.plHide.getLogger().error("Error SQL: Could open a connection");
                this.plHide.getLogger().debug("Error SQL: Could open a connection");
                return;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dataFolderPath.toString() + "/data.db", "", "");
        }
        catch (ClassNotFoundException | SQLException exception) {
            exception.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            if (!this.getConnection().isClosed()) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void cleanUp() {
        this.update("DELETE FROM plugin_commands_info WHERE DATE<='" + Date.valueOf(LocalDate.now().minusDays(30L)) + "'");
    }

    private void loadPluginData() {
        try {
            ResultSet resultSet = this.getConnection().prepareStatement("SELECT PLUGIN, COMMAND FROM plugin_commands_info").executeQuery();
            if (!resultSet.isClosed()) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    PluginCommandsInfo.addCommand(string, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void update(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.update(arrayList);
    }

    private void update(List<String> list) {
        try {
            for (String string : list) {
                this.getConnection().prepareStatement(string).executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void submitPluginData(String string, HashSet<String> hashSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : hashSet) {
            String string3 = string + string2;
            arrayList.add("INSERT or REPLACE INTO plugin_commands_info VALUES (\"" + string + "\",\"" + string2 + "\",\"" + Date.valueOf(LocalDate.now()) + "\"," + string3.hashCode() + ");");
        }
        this.update(arrayList);
    }

    public void submitPluginData(HashMap<String, HashSet<String>> hashMap) {
        hashMap.forEach(this::submitPluginData);
    }

    private Connection getConnection() {
        return this.connection;
    }
}

