/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.miscellaneous;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DebugLogger {
    private final String path;
    private PrintWriter writer;
    private boolean isActive;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public DebugLogger(String string, boolean bl) {
        this.isActive = bl;
        this.path = string;
        if (bl) {
            this.createFile();
        }
    }

    private void createFile() {
        try {
            Object object;
            File file2 = new File(this.path + "/debug.log");
            if (file2.exists()) {
                if (this.getFileNumber(1) > 5) {
                    file2.delete();
                    for (File file3 : object = new File(this.path).listFiles((file, string) -> {
                        if (string.startsWith("debug-") && string.endsWith(".log")) {
                            int n = string.indexOf("-") + 1;
                            try {
                                int n2 = Integer.parseInt(String.valueOf(string.charAt(n)));
                                if (n2 <= 5) {
                                    return true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                return false;
                            }
                        }
                        return false;
                    })) {
                        file3.delete();
                    }
                } else {
                    object = new File(this.path + "/debug-" + this.getFileNumber(1) + ".log");
                    file2.renameTo((File)object);
                }
            }
            object = new FileWriter(this.path + "/debug.log");
            this.writer = new PrintWriter((Writer)object, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int getFileNumber(int n) {
        File file = n > 0 ? new File(this.path + "/debug-" + n + ".log") : new File(this.path + "/debug.log");
        if (file.exists()) {
            n = this.getFileNumber(n + 1);
        }
        return n;
    }

    public void log(String string) {
        if (!this.isActive) {
            return;
        }
        LocalTime localTime = LocalTime.now();
        String string2 = "[%s] %s";
        this.executor.submit(() -> this.write(String.format(string2, localTime.format(this.formatter), string)));
    }

    private void write(String string) {
        this.writer.write(string);
        this.writer.println();
    }

    public void close() {
        if (this.isActive) {
            this.writer.flush();
            this.writer.close();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        if (!bl && this.isActive) {
            this.close();
        } else if (bl && !this.isActive) {
            this.createFile();
        }
        this.isActive = bl;
    }
}

