/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.modifier;

import eu.nononitas.plhidepro.api.group.GroupMode;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.group.Node;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class CommandBlocker {
    private final PlHidePlayer plHidePlayer;
    private final List<String> commandSplittedList;

    public CommandBlocker(PlHidePlayer plHidePlayer, String string) {
        this.plHidePlayer = plHidePlayer;
        this.commandSplittedList = new ArrayList<String>(Arrays.asList(string.toLowerCase(Locale.ROOT).split(" ")));
    }

    public boolean isBlocked() {
        IGroup iGroup = this.plHidePlayer.getGroup();
        Node<String> node = iGroup.getRootCommandNode();
        if (this.plHidePlayer.getGroupModeCommands() == GroupMode.BLACKLIST) {
            if (this.commandSplittedList.get(0).contains(":")) {
                if (this.plHidePlayer.unblockPluginNamedCommandsExecution()) {
                    return !this.applyWhitelist(node);
                }
                return true;
            }
            return !this.applyWhitelist(node);
        }
        return this.applyWhitelist(node);
    }

    private boolean applyWhitelist(Node<String> node) {
        if (this.commandSplittedList.isEmpty()) {
            return node.hasChildren() && !node.containsChildren("~");
        }
        String string = this.commandSplittedList.remove(0);
        if (node.isRoot() && !node.containsChildren(string)) {
            return true;
        }
        if (node.hasChildren()) {
            if (node.containsChildren("~") && node.getChildren().size() == 1) {
                return true;
            }
            if (node.containsChildren(string)) {
                return this.applyWhitelist(node.getChild(string));
            }
            if (node.containsChildren("*")) {
                return this.applyWhitelist(node.getChild("*"));
            }
            return true;
        }
        return false;
    }
}

