/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.impl;

import eu.nononitas.plhidepro.api.event.EventManager;
import eu.nononitas.plhidepro.api.event.SetGroupEvent;
import eu.nononitas.plhidepro.api.group.GroupMode;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.group.Group;
import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import eu.nononitas.plhidepro.spigot.impl.SpigotGroup;
import org.bukkit.entity.Player;

public class PlHideSpigotPlayer
implements PlHidePlayer {
    private final Player player;
    private Group group;
    private final PlHideProSpigot plHide;

    public PlHideSpigotPlayer(Player player, PlHideProSpigot plHideProSpigot) {
        this.player = player;
        this.plHide = plHideProSpigot;
        EventManager eventManager = plHideProSpigot.getEventManager();
        SetGroupEvent setGroupEvent = new SetGroupEvent(this, SpigotGroup.getGroup(this, plHideProSpigot));
        eventManager.executeEvent(setGroupEvent);
        this.group = (Group)setGroupEvent.getGroup();
    }

    @Override
    public <P> P getHandle() {
        return (P)this.player;
    }

    @Override
    public IGroup getGroup() {
        return this.group;
    }

    @Override
    public void updateGroup() {
        if (this.plHide.isIsUsingProxy()) {
            this.plHide.getPluginMessageHandler().sendUpdateGroupRequest(this.player);
            return;
        }
        EventManager eventManager = this.plHide.getEventManager();
        SetGroupEvent setGroupEvent = new SetGroupEvent(this, SpigotGroup.getGroup(this, this.plHide));
        eventManager.executeEvent(setGroupEvent);
        this.group = (Group)setGroupEvent.getGroup();
        if (!this.plHide.isLegacy()) {
            this.player.updateCommands();
        }
    }

    @Override
    public GroupMode getGroupModeCommands() {
        return this.player.hasPermission("plhide.blacklist.commands") ? GroupMode.BLACKLIST : GroupMode.WHITELIST;
    }

    @Override
    public GroupMode getGroupModeTabcomplete() {
        return this.player.hasPermission("plhide.blacklist.tabcomplete") ? GroupMode.BLACKLIST : GroupMode.WHITELIST;
    }

    @Override
    public boolean unblockPluginNamedCommandsExecution() {
        return this.player.hasPermission("plhide.unblock-plugin-named-commands.execution");
    }

    @Override
    public boolean unblockPluginNamedCommandsTabcomplete() {
        return this.player.hasPermission("plhide.unblock-plugin-named-commands.tabcomplete");
    }
}

