/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.listener;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommandPacket;
import dev.simplix.protocolize.api.Direction;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import dev.simplix.protocolize.api.listener.PacketReceiveEvent;
import dev.simplix.protocolize.api.listener.PacketSendEvent;
import eu.nononitas.plhidepro.api.event.PlayerExecuteCommandEvent;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.modifier.CommandBlocker;
import eu.nononitas.plhidepro.velocity.PlHideProVelocity;
import java.lang.reflect.Field;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class CommandHandler {
    private final PlHideProVelocity plhide;

    public CommandHandler(PlHideProVelocity plHideProVelocity) {
        this.plhide = plHideProVelocity;
    }

    private void handle(PacketReceiveEvent<?> packetReceiveEvent, String string) {
        Object object;
        Object object2;
        Player player = (Player)packetReceiveEvent.player().handle();
        if (!this.plhide.getPlayerManager().isRegistered(player)) {
            packetReceiveEvent.cancelled(true);
            this.plhide.getLogger().warn(String.format("Received a command execution request from %s even though the player is not registered. Aborting execution", player.getUsername()));
            return;
        }
        Object PlHPlayer = this.plhide.getPlayerManager().getPlHidePlayer(player);
        IGroup iGroup = PlHPlayer.getGroup();
        CharSequence[] charSequenceArray = string.split(" ");
        if (this.plhide.getConfig().getBoolean("auto_lowercase_base_commands")) {
            charSequenceArray[0] = charSequenceArray[0].toLowerCase();
            object2 = packetReceiveEvent.packet();
            object = this.plhide.getLogger();
            if (object2 instanceof KeyedPlayerCommandPacket || object2 instanceof SessionPlayerCommandPacket) {
                try {
                    Field field = object2.getClass().getDeclaredField("command");
                    field.setAccessible(true);
                    field.set(object2, String.join((CharSequence)" ", charSequenceArray));
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    object.error("Couldn't lowercase base command for KeyedPlayerCommandPacket. Reason: " + reflectiveOperationException.getCause().getMessage() + " " + reflectiveOperationException.getMessage());
                }
            }
        }
        if (charSequenceArray[0].equalsIgnoreCase("pl") || charSequenceArray[0].equalsIgnoreCase("bukkit:pl") || charSequenceArray[0].equalsIgnoreCase("plugins") || charSequenceArray[0].equalsIgnoreCase("bukkit:plugins")) {
            if (!player.hasPermission("plhide.bypass.pl-message")) {
                object2 = this.plhide.getConfigHandler().getColorTranslatedTextComponent("/pl-message");
                if (object2 != null && !object2.content().equals("none")) {
                    player.sendMessage((Component)object2);
                }
                packetReceiveEvent.cancelled(true);
                return;
            }
            return;
        }
        if (!iGroup.getGroupNames().isEmpty()) {
            boolean bl;
            PlayerExecuteCommandEvent playerExecuteCommandEvent;
            object2 = this.plhide.getConfigHandler().getColorTranslatedString("groups", iGroup.getGroupNames().get(0), "blocked-command-message");
            if (object2 == null) {
                this.plhide.getLogger().error("The option blocked-command-message is missing for the group " + iGroup.getGroupNames().get(0) + ". Using default message");
                object2 = "Unknown command. Type \"/help\" for help.";
            }
            if ((playerExecuteCommandEvent = new PlayerExecuteCommandEvent((PlHidePlayer)PlHPlayer, string, bl = ((CommandBlocker)(object = new CommandBlocker((PlHidePlayer)PlHPlayer, string))).isBlocked(), (String)object2)).isBlocked()) {
                object2 = playerExecuteCommandEvent.getBlockedMessage();
                if (object2 != null && !((String)object2).equals("none")) {
                    object2 = playerExecuteCommandEvent.getBlockedMessage().replace("{player}", player.getUsername()).replace("{cmd}", string);
                    player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize((String)object2));
                }
                packetReceiveEvent.cancelled(true);
                this.plhide.getLogger().debug("Command: " + playerExecuteCommandEvent.getCommand() + " was blocked for " + player.getUsername() + " | Groupmode: " + PlHPlayer.getGroupModeCommands());
            }
        }
    }

    public class LegacyCommandListener
    extends AbstractPacketListener<LegacyChatPacket> {
        public LegacyCommandListener() {
            super(LegacyChatPacket.class, Direction.UPSTREAM, 1);
        }

        public void packetReceive(PacketReceiveEvent<LegacyChatPacket> packetReceiveEvent) {
            LegacyChatPacket legacyChatPacket = (LegacyChatPacket)packetReceiveEvent.packet();
            if (legacyChatPacket.getMessage().startsWith("/")) {
                CommandHandler.this.handle(packetReceiveEvent, legacyChatPacket.getMessage().substring(1));
            }
        }

        public void packetSend(PacketSendEvent<LegacyChatPacket> packetSendEvent) {
        }
    }

    public class SessionCommandListener
    extends AbstractPacketListener<SessionPlayerCommandPacket> {
        public SessionCommandListener() {
            super(SessionPlayerCommandPacket.class, Direction.UPSTREAM, 1);
        }

        public void packetReceive(PacketReceiveEvent<SessionPlayerCommandPacket> packetReceiveEvent) {
            SessionPlayerCommandPacket sessionPlayerCommandPacket = (SessionPlayerCommandPacket)packetReceiveEvent.packet();
            CommandHandler.this.handle(packetReceiveEvent, sessionPlayerCommandPacket.getCommand());
        }

        public void packetSend(PacketSendEvent<SessionPlayerCommandPacket> packetSendEvent) {
        }
    }

    public class KeyedCommandListener
    extends AbstractPacketListener<KeyedPlayerCommandPacket> {
        public KeyedCommandListener() {
            super(KeyedPlayerCommandPacket.class, Direction.UPSTREAM, 1);
        }

        public void packetReceive(PacketReceiveEvent<KeyedPlayerCommandPacket> packetReceiveEvent) {
            KeyedPlayerCommandPacket keyedPlayerCommandPacket = (KeyedPlayerCommandPacket)packetReceiveEvent.packet();
            CommandHandler.this.handle(packetReceiveEvent, keyedPlayerCommandPacket.getCommand());
        }

        public void packetSend(PacketSendEvent<KeyedPlayerCommandPacket> packetSendEvent) {
        }
    }
}

