/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.listener;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponsePacket;
import dev.simplix.protocolize.api.Direction;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import dev.simplix.protocolize.api.listener.PacketReceiveEvent;
import dev.simplix.protocolize.api.listener.PacketSendEvent;
import dev.simplix.protocolize.api.player.ProtocolizePlayer;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.modifier.TabCompleteEditor;
import eu.nononitas.plhidepro.velocity.PlHideProVelocity;
import eu.nononitas.plhidepro.velocity.listener.TabCompleteRequestListener;
import java.util.ArrayList;
import java.util.List;

public class TabCompleteResponseListener
extends AbstractPacketListener<TabCompleteResponsePacket> {
    private final PlHideProVelocity plhide;

    public TabCompleteResponseListener(PlHideProVelocity plHideProVelocity) {
        super(TabCompleteResponsePacket.class, Direction.UPSTREAM, 1);
        this.plhide = plHideProVelocity;
    }

    public void packetReceive(PacketReceiveEvent<TabCompleteResponsePacket> packetReceiveEvent) {
    }

    public void packetSend(PacketSendEvent<TabCompleteResponsePacket> packetSendEvent) {
        ProtocolizePlayer protocolizePlayer = packetSendEvent.player();
        Player player = (Player)protocolizePlayer.handle();
        if (!this.plhide.getPlayerManager().isRegistered(player)) {
            packetSendEvent.cancelled(true);
            this.plhide.getLogger().warn(String.format("Received a tabcompletion request from %s even though he is not registered. Aborting completion", player.getUsername()));
            return;
        }
        Object PlHPlayer = this.plhide.getPlayerManager().getPlHidePlayer(player);
        String string2 = TabCompleteRequestListener.inputMessageMap.get(protocolizePlayer.uniqueId());
        TabCompleteResponsePacket tabCompleteResponsePacket = (TabCompleteResponsePacket)packetSendEvent.packet();
        List list = tabCompleteResponsePacket.getOffers();
        if (string2.startsWith("/")) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (TabCompleteResponsePacket.Offer offer2 : list) {
                arrayList.add(offer2.getText());
            }
            list.clear();
            if (player.getProtocolVersion().getProtocol() >= 393) {
                string2 = string2.substring(1);
            }
            TabCompleteEditor tabCompleteEditor = new TabCompleteEditor((PlHidePlayer)PlHPlayer, string2, (List<String>)arrayList);
            if (player.getProtocolVersion().getProtocol() < 393) {
                tabCompleteEditor.setLegacyCompletion();
            }
            tabCompleteEditor.change();
            arrayList.stream().distinct().forEach(string -> list.add(new TabCompleteResponsePacket.Offer(string)));
        } else {
            if (player.getProtocolVersion().getProtocol() >= 393) {
                list.clear();
                return;
            }
            list.removeIf(offer -> offer.getText().startsWith("/"));
        }
    }
}

