/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.constants.ShopBuyLimitTypeEnum;
import com.handy.guild.enter.GuildShop;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildShopService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddShopCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addShop";
    }

    @Override
    public String permission() {
        return "playerGuild.addShop";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Integer price = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        Integer level = 1;
        if (args.length > 2) {
            level = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        }
        Integer number = 0;
        if (args.length > 3) {
            number = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        }
        String type = ShopBuyLimitTypeEnum.ONLY.getName();
        if (args.length > 4) {
            ShopBuyLimitTypeEnum buyType = ShopBuyLimitTypeEnum.getEnum(args[4]);
            AssertUtil.notNull((Object)buyType, sender, BaseUtil.getMsgNotColor("typeFailureMsg") + " " + args[4]);
            type = buyType.getName();
        }
        Integer finalLevel = level;
        Integer finalNumber = number;
        String finalType = type;
        GuildShop guildShop = new GuildShop();
        guildShop.setPrice(price);
        guildShop.setLevel(finalLevel);
        guildShop.setNumber(finalNumber);
        guildShop.setType(finalType);
        guildShop.setGuildInfoId(0);
        guildShop.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        int rst = GuildShopService.getInstance().add(guildShop);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst > 0 ? "succeedMsg" : "failureMsg"));
    }
}

