/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class LookCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "look";
    }

    @Override
    public String permission() {
        return "playerGuild.look";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (args.length > 1) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByGuildName(args[1]);
            AssertUtil.isTrue(guildInfoOptional.isPresent(), sender, BaseUtil.getMsgNotColor("noGuildMsg"));
            GuildInfo guildInfo = guildInfoOptional.get();
            List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildInfo.getId());
            List onePlayerNameList = guildPlayerList.stream().filter(t -> t.getRoleId() == 1).map(GuildPlayer::getPlayerName).collect(Collectors.toList());
            List twoPlayerNameList = guildPlayerList.stream().filter(t -> t.getRoleId() == 2).map(GuildPlayer::getPlayerName).collect(Collectors.toList());
            List threePlayerNameList = guildPlayerList.stream().filter(t -> t.getRoleId() == 3).map(GuildPlayer::getPlayerName).collect(Collectors.toList());
            List fourPlayerNameList = guildPlayerList.stream().filter(t -> t.getRoleId() == 4).map(GuildPlayer::getPlayerName).collect(Collectors.toList());
            String titleMsg = ChatColor.GRAY + "_________________/ &e" + guildInfo.getGuildName() + ChatColor.GRAY + " \\_________________\n";
            String oneMsg = "&7| " + GuildRoleEnum.getRoleName(GuildRoleEnum.ONE) + ": " + CollUtil.listToStr(onePlayerNameList) + "\n";
            String twoMsg = "&7| " + GuildRoleEnum.getRoleName(GuildRoleEnum.TWO) + ": " + CollUtil.listToStr(twoPlayerNameList) + "\n";
            String threeMsg = "&7| " + GuildRoleEnum.getRoleName(GuildRoleEnum.THREE) + ": " + CollUtil.listToStr(threePlayerNameList) + "\n";
            String fourMsg = "&7| " + GuildRoleEnum.getRoleName(GuildRoleEnum.FOUR) + ": " + CollUtil.listToStr(fourPlayerNameList) + "\n";
            String msg = ChatColor.GRAY + "----------------------------------------";
            MessageUtil.sendMessage(sender, titleMsg);
            MessageUtil.sendMessage(sender, oneMsg);
            MessageUtil.sendMessage(sender, twoMsg);
            MessageUtil.sendMessage(sender, threeMsg);
            MessageUtil.sendMessage(sender, fourMsg);
            MessageUtil.sendMessage(sender, msg);
            return;
        }
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty()) {
            MessageUtil.sendMessage(sender, "&a\u5f53\u524d\u6ca1\u6709\u5f00\u59cb\u7684\u5339\u914d\u516c\u4f1a\u6218");
        } else {
            MessageUtil.sendMessage(sender, "&a\u5f53\u524d\u6709\u5f00\u59cb\u7684\u5339\u914d\u516c\u4f1a\u6218");
        }
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty()) {
            MessageUtil.sendMessage(sender, "&a\u5f53\u524d\u6ca1\u6709\u5f00\u59cb\u7684\u8d5b\u5b63\u516c\u4f1a\u6218");
        } else {
            MessageUtil.sendMessage(sender, "&a\u5f53\u524d\u6709\u5f00\u59cb\u7684\u8d5b\u5b63\u516c\u4f1a\u6218");
        }
    }
}

