/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.constants.EquipmentSlotEnum;
import com.handy.guild.enter.GuildEquipment;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildEquipmentService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SetEquipmentCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setEquipment";
    }

    @Override
    public String permission() {
        return "playerGuild.setEquipment";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        EquipmentSlotEnum equipmentSlotEnum;
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        GuildEquipment guildEquipment = new GuildEquipment();
        if (args.length > 1 && (equipmentSlotEnum = EquipmentSlotEnum.getType(args[1])) != null) {
            guildEquipment.setSlot(equipmentSlotEnum.getType());
        }
        guildEquipment.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        int rst = GuildEquipmentService.getInstance().add(guildEquipment);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst > 0 ? "succeedMsg" : "failureMsg"));
    }
}

