/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AcceptCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "accept";
    }

    @Override
    public String permission() {
        return "playerGuild.accept";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer applyId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        AcceptCommand.accept(player, applyId);
    }

    public static synchronized void accept(Player player, Integer applyId) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guild = guildPlayerOptional.get();
        if (guild.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildApply> guildApplyOptional = GuildApplyService.getInstance().findById(applyId);
        if (!guildApplyOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noApply"));
            return;
        }
        GuildApply guildApply = guildApplyOptional.get();
        if (ApplyTypeEnum.CANCEL.getId().equals(guildApply.getApplyResult())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noApply").replace("${player}", guildApply.getPlayerName()));
            return;
        }
        if (!ApplyTypeEnum.PENDING.getId().equals(guildApply.getApplyResult())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("refuseFailureMsg").replace("${applyPlayerName}", guildApply.getApplyPlayerName()));
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guild.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildInfo.getMemberCount() + 1 > guildInfo.getMemberMaxCount()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("numberFailureMsg"));
            return;
        }
        GuildApplyService.getInstance().updateApplyResultByPlayerName(guildApply.getPlayerName(), ApplyTypeEnum.CANCEL.getId());
        guildApply.setApplyResult(ApplyTypeEnum.AGREE.getId());
        guildApply.setApplyPlayerName(player.getName());
        guildApply.setApplyPlayerUuid(player.getUniqueId().toString());
        GuildApplyService.getInstance().updateById(guildApply);
        AcceptCommand.getGuildPlayer(player, guildApply.getPlayerName(), guildApply.getPlayerUuid(), guildInfo);
    }

    public static void getGuildPlayer(Player player, String playerName, String playerUuid, GuildInfo guildInfo) {
        GuildPlayer guildPlayer = new GuildPlayer();
        guildPlayer.setGuildInfoId(guildInfo.getId());
        guildPlayer.setGuildInfoName(guildInfo.getGuildName());
        guildPlayer.setPlayerName(playerName);
        guildPlayer.setPlayerUuid(playerUuid);
        guildPlayer.setPvpStatus(guildInfo.getPvpStatus());
        guildPlayer.setRoleId(GuildRoleEnum.FOUR.getRoleId());
        GuildPlayerService.getInstance().add(guildPlayer);
        Optional<Player> applyPlayer = BaseUtil.getOnlinePlayer(playerName);
        applyPlayer.ifPresent(value -> GuildConstants.PLAYER_GUILD_MAP.put(value.getUniqueId(), guildPlayer));
        GuildInfoService.getInstance().addMemberCount(guildInfo.getId(), 1);
        String joinApplyAcceptMsg = BaseUtil.getMsgNotColor("joinApplyAcceptMsg", "");
        if (player != null) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("acceptSucceedMsg").replace("${player}", playerName));
            joinApplyAcceptMsg = joinApplyAcceptMsg.replace("${player}", player.getName()).replace("${guild_name}", guildInfo.getGuildName());
        } else {
            joinApplyAcceptMsg = joinApplyAcceptMsg.replace("${player}", ConfigUtil.SETTING_CONFIG.getString("joinMode.auto", ""));
        }
        MessageUtil.sendMessage(playerName, joinApplyAcceptMsg);
        PlayerTitleUtil.addGuildPlayerTitle(playerName, guildInfo.getTitleId());
    }
}

