/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditGuildNameCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "editGuildName";
    }

    @Override
    public String permission() {
        return "playerGuild.editGuildName";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String guildName = args[1].trim();
        EditGuildNameCommand.editGuildName(player, guildName);
    }

    public static void editGuildName(Player player, String guildName) {
        int guildNameLength = ConfigUtil.CREATE_CONFIG.getInt("guildNameLength");
        if (BaseUtil.stripColor(guildName).length() > guildNameLength) {
            String lengthFailureMsg = ConfigUtil.CREATE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", guildNameLength + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return;
        }
        if ((guildName.contains("&") || guildName.contains("\u00a7")) && !player.hasPermission("playerguild.create.color")) {
            String colorFailureMsg = ConfigUtil.CREATE_CONFIG.getString("colorFailureMsg", "&4\u4f60\u6ca1\u6709 &aplayerguild.create.color &4\u6743\u9650\u6765\u521b\u5efa\u5f69\u8272\u540d\u79f0\u7684\u516c\u4f1a");
            MessageUtil.sendMessage(player, colorFailureMsg);
            return;
        }
        List nameBlackList = ConfigUtil.CREATE_CONFIG.getStringList("nameBlackList");
        for (String nameBlack : nameBlackList) {
            if (!guildName.contains(nameBlack)) continue;
            String nameBlackListFailureMsg = ConfigUtil.CREATE_CONFIG.getString("nameBlackListFailureMsg", "").replace("${name}", nameBlack);
            MessageUtil.sendMessage(player, nameBlackListFailureMsg);
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildInfo> infoOptional = GuildInfoService.getInstance().findByGuildName(guildName);
        if (infoOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("duplicateName"));
            return;
        }
        int price = ConfigUtil.SETTING_CONFIG.getInt("editName.price");
        if (guildInfo.getMoney() < price) {
            MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("editName.noButton"));
            return;
        }
        String replaceGuildName = guildName.replace("\u00a7", "&");
        GuildInfoService.getInstance().editGuildName(guildInfo.getId(), replaceGuildName, price);
        WorldUtil.setWorldAlias(guildInfo.getWorldName(), replaceGuildName);
        PlayerTitleUtil.setGuildTitle(guildInfo.getId());
        String editNameOkButton = ConfigUtil.SETTING_CONFIG.getString("editName.okButton", "").replace("${guildName}", guildName);
        MessageUtil.sendMessage(player, editNameOkButton);
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildInfo.getId());
        for (GuildPlayer guildPlayer1 : guildPlayerList) {
            UUID uuid = UUID.fromString(guildPlayer1.getPlayerUuid());
            if (!GuildConstants.PLAYER_GUILD_MAP.containsKey(uuid)) continue;
            GuildConstants.PLAYER_GUILD_MAP.put(uuid, guildPlayer1);
        }
    }
}

