/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.constants;

import com.handy.guild.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.List;

public enum GuildActivityType {
    SEASON("season", "activityType.season"),
    MATCH("mate", "activityType.match");

    private final String type;
    private final String typeName;

    public static List<String> getPvpLocationType() {
        ArrayList<String> typeList = new ArrayList<String>();
        for (GuildActivityType guildActivityType : GuildActivityType.values()) {
            typeList.add(guildActivityType.type);
        }
        return typeList;
    }

    public static GuildActivityType getType(String type) {
        for (GuildActivityType guildActivityType : GuildActivityType.values()) {
            if (!guildActivityType.type.equals(type)) continue;
            return guildActivityType;
        }
        return null;
    }

    public static String getTypeName(GuildActivityType guildActivityType) {
        return BaseUtil.getLangMsg(guildActivityType.typeName);
    }

    private GuildActivityType(String type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public String getType() {
        return this.type;
    }
}

