/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.hook;

import com.handy.guild.PlayerGuild;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.util.ConfigUtil;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.bukkit.Location;

public class WorldEditUtil {
    private WorldEditUtil() {
    }

    public static void create(Location location) {
        if (!PlayerGuild.USE_WORLD_EDIT || !ConfigUtil.WORLD_EDIT_CONFIG.getBoolean("enable", true)) {
            return;
        }
        String schemName = ConfigUtil.WORLD_EDIT_CONFIG.getString("schemName", "");
        String schemNameFile = PlayerGuild.INSTANCE.getDataFolder().getAbsolutePath() + "/function/" + schemName;
        File schemFile = new File(schemNameFile);
        if (!schemFile.exists()) {
            MessageUtil.sendConsoleMessage("[SchematicPaste] Schematic not found!");
            return;
        }
        Clipboard clipboard = null;
        ClipboardFormat format = ClipboardFormats.findByFile((File)schemFile);
        if (format != null) {
            try (ClipboardReader reader = format.getReader(Files.newInputStream(schemFile.toPath(), new OpenOption[0]));){
                clipboard = reader.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (clipboard == null) {
            MessageUtil.sendConsoleMessage("[SchematicPaste]  clipboard is null!");
            return;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        if (ConfigUtil.WORLD_EDIT_CONFIG.getBoolean("customLocation.enable")) {
            x = ConfigUtil.WORLD_EDIT_CONFIG.getDouble("customLocation.x");
            y = ConfigUtil.WORLD_EDIT_CONFIG.getDouble("customLocation.y");
            z = ConfigUtil.WORLD_EDIT_CONFIG.getDouble("customLocation.z");
        }
        BukkitWorld bukkitWorld = new BukkitWorld(location.getWorld());
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)bukkitWorld, -1);){
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((double)x, (double)y, (double)z)).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
        }
        catch (WorldEditException e) {
            e.printStackTrace();
        }
    }
}

