/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildApplyGui {
    private static final GuildApplyGui INSTANCE = new GuildApplyGui();

    private GuildApplyGui() {
    }

    public static GuildApplyGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.APPLY_CONFIG.getString("title");
        int size = ConfigUtil.APPLY_CONFIG.getInt("size", 54);
        title = PlaceholderApiUtil.set(player, title);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_APPLY.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_APPLY.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildApply> page = GuildApplyService.getInstance().page(handyInventory.getId(), handyInventory.getPageNum(), handyInventory.getPageSize(), ApplyTypeEnum.PENDING.getId());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildApply> records = page.getRecords();
        String name = ConfigUtil.APPLY_CONFIG.getString("member.name", "");
        String materialStr = ConfigUtil.APPLY_CONFIG.getString("member.material");
        int customModelDataId = ConfigUtil.APPLY_CONFIG.getInt("member.custom-model-data");
        List<String> loreList = ConfigUtil.APPLY_CONFIG.getStringList("member.lore");
        boolean hideFlag = ConfigUtil.APPLY_CONFIG.getBoolean("member.hideFlag", true);
        HashMap<Integer, ItemStack> itemStackMap = MapUtil.newHashMapWithExpectedSize(records.size());
        for (GuildApply guildApply : records) {
            String newName = name.replace("${player_name}", BaseUtil.replaceChatColor(guildApply.getPlayerName()));
            loreList = PlaceholderApiUtil.set(Bukkit.getOfflinePlayer((UUID)UUID.fromString(guildApply.getPlayerUuid())), loreList);
            ItemStack itemStack = ItemStackUtil.getItemStack(materialStr, newName, loreList, true, customModelDataId, hideFlag, this.replaceMap(guildApply));
            itemStackMap.put(guildApply.getId(), itemStack);
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (Integer guildPlayerId : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(guildPlayerId));
            map.put(index, guildPlayerId);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.APPLY_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.APPLY_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.APPLY_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.APPLY_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(GuildApply guildApply) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(2);
        replaceMap.put("player_name", BaseUtil.replaceChatColor(guildApply.getPlayerName()));
        replaceMap.put("apply_Time", DateUtil.format(guildApply.getApplyTime(), "yyyy-MM-dd HH:mm:ss"));
        return replaceMap;
    }
}

